/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Aspect;

public class Timeout
implements Aspect {
    private int seconds;

    public Timeout(int seconds) {
        this.seconds = seconds;
    }

    @Override
    public String before(String application, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append("with timeout of ").append(this.seconds).append(" second");
        if (this.seconds != 1) {
            sb.append('s');
        }
        return sb.toString();
    }

    @Override
    public String after(String application, String body) {
        return "end timeout";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timeout timeout = (Timeout)o;
        return this.seconds == timeout.seconds;
    }

    public int hashCode() {
        return this.seconds;
    }

    public String toString() {
        return "Timeout{seconds=" + this.seconds + '}';
    }
}

