/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import com.tagtraum.japlscript.JaplScriptException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledScript {
    private static final Logger LOG = LoggerFactory.getLogger(CompiledScript.class);
    private CharSequence script;
    private String scriptFile;

    public CompiledScript(CharSequence script, String scriptFile) {
        this.script = script;
        this.scriptFile = scriptFile;
    }

    public CharSequence getScript() {
        return this.script;
    }

    public String execute() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"osascript", this.scriptFile});
        ReaderPump stderr = new ReaderPump(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        ReaderPump stdout = new ReaderPump(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Thread errThread = new Thread(stderr);
        Thread outThread = new Thread(stdout);
        errThread.start();
        outThread.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        try {
            errThread.join();
            outThread.join();
        }
        catch (InterruptedException e) {
            IOException ioe = new IOException(e.toString());
            ioe.initCause(e);
            throw ioe;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exit value  : " + process.exitValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Return value: " + stdout.getValue());
        }
        if (stderr.getIOException() != null) {
            throw stderr.getIOException();
        }
        if (stdout.getIOException() != null) {
            throw stdout.getIOException();
        }
        if (stderr.getValue().length() > 0) {
            throw new JaplScriptException(stderr.getValue(), this.script.toString());
        }
        return stdout.getValue();
    }

    private static class ReaderPump
    implements Runnable {
        private Reader in;
        private String value;
        private IOException ioException;
        private static final int ONE_KB = 1024;

        public ReaderPump(Reader in) {
            this.in = in;
        }

        public String getValue() {
            return this.value;
        }

        public IOException getIOException() {
            return this.ioException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder();
            int count = 0;
            try {
                while ((count = this.in.read(cbuf)) != -1) {
                    sb.append(cbuf, 0, count);
                }
                this.value = sb.toString().trim();
            }
            catch (IOException ioe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ioe.toString(), (Throwable)ioe);
                }
                this.value = ioe.toString();
                this.ioException = ioe;
            }
            finally {
                block14: {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(e.toString(), (Throwable)e);
                    }
                }
            }
        }
    }
}

