/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeLibraryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibraryLoader.class);
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String NATIVE_LIBRARY_EXTENSION = System.getProperty("os.name").toLowerCase().contains("mac") ? ".dylib" : ".dll";
    private static final String NATIVE_LIBRARY_PREFIX = "lib";
    private static final Set<String> LOADED = new HashSet<String>();
    private static final String OS_ARCH = "-" + System.getProperty("os.arch");
    private static final String VERSION = NativeLibraryLoader.readProjectVersion();
    private static Boolean japlscriptLibraryLoaded;

    private NativeLibraryLoader() {
    }

    public static synchronized boolean loadLibrary() {
        if (japlscriptLibraryLoaded != null) {
            return japlscriptLibraryLoaded;
        }
        boolean loaded = false;
        try {
            String arch = System.getProperty("os.arch");
            if ("aarch64".equals(arch) || "arm64".equals(arch)) {
                NativeLibraryLoader.loadLibrary("japlscript-aarch64");
            } else {
                NativeLibraryLoader.loadLibrary("japlscript-x86_64");
            }
            loaded = true;
        }
        catch (Error e) {
            java.util.logging.Logger.getLogger(NativeLibraryLoader.class.getName()).severe("Failed to load native library 'casampledsp'. Please check your library path. CASampledSP will be dysfunctional.");
        }
        japlscriptLibraryLoaded = loaded;
        return japlscriptLibraryLoaded;
    }

    public static synchronized void loadLibrary(String libName) {
        NativeLibraryLoader.loadLibrary(libName, NativeLibraryLoader.class);
    }

    public static synchronized void loadLibrary(String libName, Class<?> baseClass) {
        String key = libName + "|" + baseClass.getName();
        if (LOADED.contains(key)) {
            return;
        }
        String packagedNativeLib = libName + "-" + VERSION + NATIVE_LIBRARY_EXTENSION;
        File extractedNativeLib = new File(System.getProperty("java.io.tmpdir") + "/" + packagedNativeLib);
        if (!extractedNativeLib.exists()) {
            NativeLibraryLoader.extractResourceToFile(baseClass, "/" + packagedNativeLib, extractedNativeLib);
        }
        if (extractedNativeLib.exists()) {
            try {
                Runtime.getRuntime().load(extractedNativeLib.toString());
                LOADED.add(key);
                return;
            }
            catch (Error error) {
                // empty catch block
            }
        }
        try {
            System.loadLibrary(libName);
            LOADED.add(key);
        }
        catch (Error e) {
            try {
                String libFilename = NativeLibraryLoader.findFile(libName, baseClass, new LibFileFilter(libName));
                Runtime.getRuntime().load(libFilename);
                LOADED.add(key);
            }
            catch (FileNotFoundException e1) {
                throw e;
            }
        }
    }

    private static void extractResourceToFile(Class<?> baseClass, String sourceResource, File targetFile) {
        block27: {
            try (InputStream in = baseClass.getResourceAsStream(sourceResource);){
                if (in == null) break block27;
                try (FileOutputStream out = new FileOutputStream(targetFile);){
                    int justRead;
                    byte[] buf = new byte[8192];
                    while ((justRead = in.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, justRead);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String findFile(String name, Class<?> baseClass, FileFilter filter) throws FileNotFoundException {
        try {
            File directory = NativeLibraryLoader.getClasspathOrJarDir(baseClass);
            File[] libs = directory.listFiles(filter);
            if (libs == null || libs.length == 0) {
                throw new FileNotFoundException("No matching files in " + directory);
            }
            return libs[0].toString();
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            FileNotFoundException fnfe = new FileNotFoundException(name + ": " + e.toString());
            fnfe.initCause(e);
            throw fnfe;
        }
    }

    public static File getClasspathOrJarDir(Class<?> baseClass) throws UnsupportedEncodingException, MalformedURLException, FileNotFoundException {
        File directory = null;
        URL url = baseClass.getResource(baseClass.getSimpleName() + CLASS_FILE_EXTENSION);
        if (url == null) {
            throw new FileNotFoundException("Failed to get URL of " + baseClass.getName());
        }
        String path = NativeLibraryLoader.decodeURL(url.getPath());
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            String jarFileName = new URL(path.substring(0, path.lastIndexOf(33))).getPath();
            directory = new File(jarFileName).getParentFile();
        } else if (FILE_PROTOCOL.equals(url.getProtocol())) {
            directory = new File(path.substring(0, path.length() - baseClass.getName().length() - CLASS_FILE_EXTENSION.length()));
        }
        return directory;
    }

    public static String decodeURL(String s) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        while (i < numChars) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < numChars && c == '%') {
                        int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        if (v < 0) {
                            throw new IllegalArgumentException("NativeLibraryLoader: Illegal hex characters in escape (%) pattern - negative value");
                        }
                        bytes[pos++] = (byte)v;
                        if ((i += 3) >= numChars) continue;
                        c = s.charAt(i);
                    }
                    if (i < numChars && c == '%') {
                        throw new IllegalArgumentException("NativeLibraryLoader: Incomplete trailing escape (%) pattern");
                    }
                    sb.append(new String(bytes, 0, pos, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("NativeLibraryLoader: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                }
                needToChange = true;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    private static String readProjectVersion() {
        try {
            Properties properties = new Properties();
            properties.load(NativeLibraryLoader.class.getResourceAsStream("project.properties"));
            return properties.getProperty("version", "unknown");
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static class LibFileFilter
    implements FileFilter {
        private final String libName;

        public LibFileFilter(String libName) {
            this.libName = libName;
        }

        @Override
        public boolean accept(File file) {
            String fileString = file.toString();
            String fileName = file.getName();
            return file.isFile() && (fileName.startsWith(this.libName) || fileName.startsWith(NativeLibraryLoader.NATIVE_LIBRARY_PREFIX + this.libName)) && fileString.endsWith(NATIVE_LIBRARY_EXTENSION);
        }
    }
}

