/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.execution.CompiledScript;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Osacompile {
    private static final Logger LOG = LoggerFactory.getLogger(Osacompile.class);
    private static final Path JAPLSCRIPT_CACHE_DIRECTORY = new File(System.getProperty("user.home") + "/Library/Caches/JaplScript/").toPath();
    private final Map<CharSequence, CompiledScript> COMPILED_SCRIPTS = new HashMap<CharSequence, CompiledScript>();

    public CompiledScript compile(CharSequence script) throws IOException {
        CompiledScript compiledScript = this.getCachedCompiledScript(script);
        if (compiledScript != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Script is already compiled.");
            }
            return compiledScript;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Script needs to be compiled.");
        }
        Path scriptFile = Files.createTempFile(JAPLSCRIPT_CACHE_DIRECTORY, "japlscript", ".scpt", new FileAttribute[0]);
        scriptFile.toFile().deleteOnExit();
        Process process = Runtime.getRuntime().exec(new String[]{"osacompile", "-o", scriptFile.toString()});
        OutputStreamWriter stdin = new OutputStreamWriter(process.getOutputStream(), "MacRoman");
        stdin.write(script.toString());
        ((Writer)stdin).close();
        ReaderPump stderr = new ReaderPump(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        ReaderPump stdout = new ReaderPump(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Thread errThread = new Thread(stderr);
        Thread outThread = new Thread(stdout);
        errThread.start();
        outThread.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        try {
            errThread.join();
            outThread.join();
        }
        catch (InterruptedException e) {
            IOException ioe = new IOException(e.toString());
            ioe.initCause(e);
            throw ioe;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exit value  : " + process.exitValue());
        }
        if (stderr.getIOException() != null) {
            throw stderr.getIOException();
        }
        if (stdout.getIOException() != null) {
            throw stdout.getIOException();
        }
        if (stderr.getValue().length() > 0) {
            throw new JaplScriptException(stderr.getValue(), script.toString());
        }
        compiledScript = new CompiledScript(script, scriptFile.toString());
        this.cacheCompiledScript(compiledScript);
        return compiledScript;
    }

    private synchronized CompiledScript getCachedCompiledScript(CharSequence script) {
        return this.COMPILED_SCRIPTS.get(script);
    }

    private synchronized CompiledScript cacheCompiledScript(CompiledScript compiledScript) {
        return this.COMPILED_SCRIPTS.put(compiledScript.getScript(), compiledScript);
    }

    static {
        try {
            Files.createDirectories(JAPLSCRIPT_CACHE_DIRECTORY, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
    }

    private static class ReaderPump
    implements Runnable {
        private Reader in;
        private String value;
        private IOException ioException;
        private static final int ONE_KB = 1024;

        public ReaderPump(Reader in) {
            this.in = in;
        }

        public String getValue() {
            return this.value;
        }

        public IOException getIOException() {
            return this.ioException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder();
            int count = 0;
            try {
                while ((count = this.in.read(cbuf)) != -1) {
                    sb.append(cbuf, 0, count);
                }
                this.value = sb.toString().trim();
            }
            catch (IOException ioe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ioe.toString(), (Throwable)ioe);
                }
                this.value = ioe.toString();
                this.ioException = ioe;
            }
            finally {
                block14: {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(e.toString(), (Throwable)e);
                    }
                }
            }
        }
    }
}

