/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.ScriptExecutor;
import com.tagtraum.japlscript.Session;
import com.tagtraum.japlscript.execution.BadScriptingAdditionException;
import com.tagtraum.japlscript.execution.CompiledScript;
import com.tagtraum.japlscript.execution.Osacompile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Osascript
extends ScriptExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(Osascript.class);
    private static Osacompile osacompile = new Osacompile();
    private static final int NO_ERRORS = 0;
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    @Override
    public String executeImpl() throws IOException {
        int exit;
        Session session = Session.getSession();
        if (session != null && session.isCompile()) {
            CompiledScript compiledScript;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using compiled script.");
            }
            if ((compiledScript = osacompile.compile(this.getScript())) != null) {
                return compiledScript.execute();
            }
        }
        String[] cmdarray = new String[]{"osascript", "-s", "s", "-"};
        Process process = Runtime.getRuntime().exec(cmdarray);
        OutputStreamWriter stdin = new OutputStreamWriter(process.getOutputStream(), "MacRoman");
        stdin.write(this.getScript().toString());
        ((Writer)stdin).close();
        ReaderPump stderr = new ReaderPump(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        ReaderPump stdout = new ReaderPump(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Future<?> outFuture = THREAD_POOL.submit(stdout);
        Future<?> errFuture = THREAD_POOL.submit(stderr);
        try {
            exit = process.waitFor();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exit value: " + exit);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        try {
            errFuture.get();
            outFuture.get();
        }
        catch (InterruptedException e) {
            IOException ioe = new IOException(e.toString());
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExecutionException e) {
            LOG.error(e.toString(), (Throwable)e);
            IOException ioe = new IOException(e.toString());
            ioe.initCause(e.getCause());
            throw ioe;
        }
        if (LOG.isDebugEnabled() && stdout.getValue() != null && stdout.getValue().length() > 0) {
            String returnValue = stdout.getValue();
            LOG.debug("Return value: " + returnValue.substring(0, Math.min(1024, returnValue.length())));
        }
        if (stderr.getIOException() != null) {
            throw stderr.getIOException();
        }
        if (stdout.getIOException() != null) {
            throw stdout.getIOException();
        }
        if (exit != 0) {
            String stderrValue = stderr.getValue();
            if (stderrValue.length() > 0) {
                if (BadScriptingAdditionException.isBadScriptingAdditionMessage(stderrValue)) {
                    throw new BadScriptingAdditionException(stderrValue);
                }
                throw new JaplScriptException(stderrValue, this.getScript().toString());
            }
            throw new JaplScriptException("Unknown Error", this.getScript().toString());
        }
        return stdout.getValue();
    }

    private static class ReaderPump
    implements Runnable {
        private Reader in;
        private String value;
        private IOException ioException;
        private static final int ONE_KB = 1024;

        public ReaderPump(Reader in) {
            this.in = in;
        }

        public String getValue() {
            return this.value;
        }

        public IOException getIOException() {
            return this.ioException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder();
            try {
                int count;
                while ((count = this.in.read(cbuf)) != -1) {
                    sb.append(cbuf, 0, count);
                }
                this.value = sb.toString().trim();
            }
            catch (IOException ioe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ioe.toString(), (Throwable)ioe);
                }
                this.value = ioe.toString();
                this.ioException = ioe;
            }
            finally {
                block14: {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(e.toString(), (Throwable)e);
                    }
                }
            }
        }
    }
}

