/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingAddition {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptingAddition.class);
    private File executable;
    private File folder;
    private Architecture architecture;

    public ScriptingAddition(File file) {
        if (ScriptingAddition.isScriptingAdditionFolder(file)) {
            this.folder = file;
            this.architecture = Architecture.UNKNOWN;
        } else {
            this.executable = file;
            this.folder = file;
            while (this.folder != null && !ScriptingAddition.isScriptingAdditionFolder(this.folder)) {
                this.folder = this.folder.getParentFile();
            }
            this.architecture = this.determineArchitecture();
        }
    }

    public File getExecutable() {
        return this.executable;
    }

    public File getFolder() {
        return this.folder;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public boolean isLocalArchitecture() {
        return this.architecture == Architecture.UNIVERSAL || System.getProperty("os.arch").equalsIgnoreCase(this.architecture.toString());
    }

    private Architecture determineArchitecture() {
        if (this.executable != null) {
            ProcessBuilder processBuilder = new ProcessBuilder("file", "-b", this.executable.toString());
            StringBuilder sb = new StringBuilder();
            processBuilder.redirectErrorStream(true);
            try {
                Process process = processBuilder.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = in.readLine();
                while (line != null) {
                    sb.append(line);
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
            }
            String s = sb.toString();
            if (s.contains("i386") && s.contains("ppc")) {
                return Architecture.UNIVERSAL;
            }
            if (s.contains("i386")) {
                return Architecture.I368;
            }
            if (s.contains("ppc")) {
                return Architecture.PPC;
            }
        }
        return Architecture.UNKNOWN;
    }

    private static boolean isScriptingAdditionFolder(File file) {
        return file.isDirectory() && file.getName().endsWith(".osax");
    }

    public String toString() {
        if (this.folder != null) {
            return "[" + (Object)((Object)this.architecture) + " binary]: " + this.folder;
        }
        return "[" + (Object)((Object)this.architecture) + " binary]: " + this.executable;
    }

    public static enum Architecture {
        I368,
        PPC,
        UNIVERSAL,
        UNKNOWN;

    }
}

