/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.types.JaplScriptFile;
import com.tagtraum.japlscript.types.ReferenceImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alias
extends ReferenceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(Alias.class);
    private Path file;
    private String alias;

    public Alias(String objectReference, String applicationReference) {
        super(Alias.toObjectReference(objectReference), applicationReference);
        int startQuote = objectReference.indexOf(34);
        if (startQuote != -1) {
            int endQuote = objectReference.lastIndexOf(34);
            this.alias = objectReference.substring(startQuote + 1, endQuote);
            this.file = Paths.get("/Volumes/" + this.alias.replace(':', '/'), new String[0]);
        } else {
            this.alias = objectReference;
            this.file = Paths.get(objectReference, new String[0]);
        }
    }

    private static String toObjectReference(String objectReference) {
        if (objectReference.startsWith("/")) {
            try {
                return JaplScriptFile.toApplescriptFile(new File(objectReference));
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
                return objectReference;
            }
        }
        return objectReference;
    }

    public Alias(Path file) throws IOException {
        super(JaplScriptFile.toApplescriptFile(file), null);
    }

    public Alias(File file) throws IOException {
        this(file.toPath());
    }

    public File getFile() {
        return this.file.toFile();
    }

    public Path getPath() {
        return this.file;
    }

    public URL getURL() throws MalformedURLException {
        return new URL("file://localhost" + this.file);
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public String toString() {
        return this.getObjectReference();
    }
}

