/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.types.ReferenceImpl;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Picture
extends ReferenceImpl {
    private byte[] data;
    private String format;

    public Picture(String objectReference, String applicationReference) {
        super(objectReference, applicationReference);
        if (objectReference.startsWith("data ", 1)) {
            this.format = objectReference.substring("<data ".length(), "<data ".length() + 4);
            String hexString = objectReference.substring("<data ".length() + 4, objectReference.length() - 1);
            ByteArrayOutputStream out = new ByteArrayOutputStream(hexString.length() / 2);
            for (int i = 0; i < hexString.length(); i += 2) {
                out.write(Integer.parseInt(hexString.substring(i, i + 2), 16));
            }
            this.data = out.toByteArray();
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Image getImage() throws IOException {
        if (this.data == null) {
            return null;
        }
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.data));
        return image;
    }

    public String getFormat() {
        return this.format;
    }
}

