/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.types.ReferenceImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tdta
extends ReferenceImpl {
    private static final Logger LOG;
    private byte[] tdta = new byte[0];
    private static final int DIM = 55;
    private static int[][] HEXMAP;

    private static int hexToInt(char[] array, int offset) {
        return HEXMAP[array[offset] - 48][array[offset + 1] - 48];
    }

    public Tdta(byte[] buf, String applicationReference) {
        super("\u00abdata tdta" + Tdta.toHex(buf) + "\u00bb", applicationReference);
        this.tdta = buf;
    }

    public Tdta(File file, String applicationReference) throws IOException {
        this("\u00abdata tdta" + Tdta.toHex(file) + "\u00bb", applicationReference);
    }

    private static String toHex(byte[] buf) {
        StringBuilder sb = new StringBuilder(buf.length * 2);
        for (byte b : buf) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toHex(File file) throws IOException {
        StringBuilder sb = new StringBuilder((int)file.length() * 2);
        FileInputStream in = null;
        try {
            int justRead;
            in = new FileInputStream(file);
            byte[] buf = new byte[65536];
            while ((justRead = in.read(buf)) > 0) {
                for (int i = 0; i < justRead; ++i) {
                    sb.append(String.format("%02X", buf[i]));
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    public Tdta(String objectReference, String applicationReference) {
        super(objectReference, applicationReference);
        if (objectReference.startsWith("data tdta", 1)) {
            String hexString = objectReference.substring("<data tdta".length(), objectReference.length() - 1);
            ByteArrayOutputStream out = new ByteArrayOutputStream(hexString.length() / 2);
            char[] chars = hexString.toCharArray();
            for (int i = 0; i < hexString.length(); i += 2) {
                try {
                    out.write(Tdta.hexToInt(chars, i));
                    continue;
                }
                catch (NumberFormatException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
            this.tdta = out.toByteArray();
        }
    }

    public byte[] getTdta() {
        return this.tdta;
    }

    public void setTdta(byte[] tdta) {
        this.tdta = tdta;
    }

    static {
        char j;
        char i;
        LOG = LoggerFactory.getLogger(Tdta.class);
        HEXMAP = new int[55][];
        for (i = '\u0000'; i < '\n'; ++i) {
            Tdta.HEXMAP[i] = new int[55];
            for (j = '\u0000'; j < '\n'; ++j) {
                Tdta.HEXMAP[i][j] = Integer.parseInt("" + i + "" + j, 16);
            }
            for (j = 'A'; j < 'G'; j = (char)((char)(j + '\u0001'))) {
                Tdta.HEXMAP[i][j - 48] = Integer.parseInt("" + i + "" + Character.toString(j), 16);
            }
            for (j = 'a'; j < 'g'; j = (char)(j + '\u0001')) {
                Tdta.HEXMAP[i][j - 48] = Integer.parseInt("" + i + "" + Character.toString(j), 16);
            }
        }
        for (i = 'A'; i < 'G'; i = (char)(i + '\u0001')) {
            Tdta.HEXMAP[i - 48] = new int[55];
            for (j = '\u0000'; j < '\n'; ++j) {
                Tdta.HEXMAP[i - 48][j] = Integer.parseInt(Character.toString(i) + j, 16);
            }
            for (j = 'A'; j < 'G'; j = (char)(j + '\u0001')) {
                Tdta.HEXMAP[i - 48][j - 48] = Integer.parseInt(Character.toString(i) + Character.toString(j), 16);
            }
            for (j = 'a'; j < 'g'; j = (char)(j + '\u0001')) {
                Tdta.HEXMAP[i - 48][j - 48] = Integer.parseInt(Character.toString(i) + Character.toString(j), 16);
            }
        }
        for (i = 'a'; i < 'g'; i = (char)(i + '\u0001')) {
            Tdta.HEXMAP[i - 48] = new int[55];
            for (j = '\u0000'; j < '\n'; ++j) {
                Tdta.HEXMAP[i - 48][j] = Integer.parseInt(Character.toString(i) + j, 16);
            }
            for (j = 'A'; j < 'G'; j = (char)(j + '\u0001')) {
                Tdta.HEXMAP[i - 48][j - 48] = Integer.parseInt(Character.toString(i) + Character.toString(j), 16);
            }
            for (j = 'a'; j < 'g'; j = (char)(j + '\u0001')) {
                Tdta.HEXMAP[i - 48][j - 48] = Integer.parseInt(Character.toString(i) + Character.toString(j), 16);
            }
        }
    }
}

