/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateParser {
    private final Locale locale;
    private final DateFormatSymbols dateFormatSymbols;
    private final SimpleDateFormat[] universalFormats;

    public DateParser(Locale locale) {
        this.locale = locale;
        this.dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        this.universalFormats = Locale.CANADA.getCountry().equals(locale.getCountry()) || Locale.US.getCountry().equals(locale.getCountry()) ? new SimpleDateFormat[]{new SimpleDateFormat("M d yyyy h.mm.ss aa", Locale.US), new SimpleDateFormat("M d yyyy H.mm.ss", Locale.US)} : (Locale.JAPAN.getLanguage().equals(locale.getLanguage()) ? new SimpleDateFormat[]{new SimpleDateFormat("yyyy M d h.mm.ss aa", Locale.US), new SimpleDateFormat("yyyy M d H.mm.ss", Locale.US)} : new SimpleDateFormat[]{new SimpleDateFormat("d M yyyy h.mm.ss aa", Locale.US), new SimpleDateFormat("d M yyyy H.mm.ss", Locale.US), new SimpleDateFormat("d. M yyyy h.mm.ss aa", Locale.US), new SimpleDateFormat("d. M yyyy H.mm.ss", Locale.US)});
        if (Locale.GERMAN.getLanguage().equals(locale.getLanguage())) {
            this.dateFormatSymbols.setAmPmStrings(new String[]{"vorm.", "nachm."});
        }
        if ("nl".equals(locale.getLanguage())) {
            this.dateFormatSymbols.setAmPmStrings(new String[]{"a.m.", "p.m."});
        }
    }

    public Date parse(String s) throws ParseException {
        Object universalDate = s;
        int month = this.getSymbolIndex(s, this.dateFormatSymbols.getMonths(), this.dateFormatSymbols.getShortMonths());
        if (month != -1) {
            if (((String)universalDate).contains(this.dateFormatSymbols.getMonths()[month])) {
                universalDate = ((String)universalDate).replace(this.dateFormatSymbols.getMonths()[month], month + 1 + " ");
            } else if (((String)universalDate).contains(this.dateFormatSymbols.getShortMonths()[month])) {
                universalDate = ((String)universalDate).replace(this.dateFormatSymbols.getShortMonths()[month], month + 1 + " ");
            }
        } else {
            String[] lowerShortMonths;
            String[] lowerMonths = this.toLowerCase(this.dateFormatSymbols.getMonths());
            month = this.getSymbolIndex(s, lowerMonths, lowerShortMonths = this.toLowerCase(this.dateFormatSymbols.getShortMonths()));
            if (month != -1) {
                if (((String)universalDate).contains(lowerMonths[month])) {
                    universalDate = ((String)universalDate).replace(lowerMonths[month], month + 1 + " ");
                } else if (((String)universalDate).contains(lowerShortMonths[month])) {
                    universalDate = ((String)universalDate).replace(lowerShortMonths[month], month + 1 + " ");
                }
            }
        }
        String am = this.dateFormatSymbols.getAmPmStrings()[0];
        String pm = this.dateFormatSymbols.getAmPmStrings()[1];
        boolean containsAM = ((String)universalDate).contains(am);
        boolean containsPM = ((String)universalDate).contains(pm);
        if (containsAM) {
            universalDate = ((String)universalDate).replace(am, "");
        }
        if (containsPM) {
            universalDate = ((String)universalDate).replace(pm, "");
        }
        StringBuilder sb = new StringBuilder();
        boolean lastIsWhiteSpace = false;
        for (char c : ((String)universalDate).toCharArray()) {
            if (!Character.isLetter(c) && c != ',' && c != '-' && c != ' ') {
                sb.append(c);
                lastIsWhiteSpace = false;
                continue;
            }
            if (lastIsWhiteSpace) continue;
            sb.append(' ');
            lastIsWhiteSpace = true;
        }
        universalDate = sb.toString();
        if (((String)universalDate).endsWith(".")) {
            universalDate = ((String)universalDate).substring(0, ((String)universalDate).length() - 1);
        }
        universalDate = ((String)universalDate).replace(':', '.').replace('/', '.').replace(" . ", " ");
        universalDate = ((String)universalDate).trim();
        if (containsAM) {
            universalDate = (String)universalDate + " AM";
        }
        if (containsPM) {
            universalDate = (String)universalDate + " PM";
        }
        universalDate = ((String)universalDate).trim();
        for (SimpleDateFormat format : this.universalFormats) {
            try {
                return format.parse((String)universalDate);
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Failed to parse " + s + " with locale " + this.locale, -1);
    }

    private String[] toLowerCase(String[] symbols) {
        String[] lower = new String[symbols.length];
        for (int i = 0; i < lower.length; ++i) {
            lower[i] = symbols[i].toLowerCase(this.locale);
        }
        return lower;
    }

    private int getSymbolIndex(String dateString, String[] symbolArray, String[] shortSymbolArray) {
        int index = this.getSymbolIndex(dateString, symbolArray);
        if (index == -1) {
            index = this.getSymbolIndex(dateString, shortSymbolArray);
        }
        return index;
    }

    private int getSymbolIndex(String dateString, String[] symbolArray) {
        int index = -1;
        for (int i = 0; i < symbolArray.length; ++i) {
            if (!dateString.contains(symbolArray[i]) || symbolArray[i].isEmpty()) continue;
            index = i;
            break;
        }
        return index;
    }
}

