/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import java.util.Objects;

public class ExecutionEvent {
    private final Object source;
    private final String script;
    private final boolean started;
    private final String result;

    public ExecutionEvent(Object source, String script, boolean started, String result) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(script);
        this.source = source;
        this.script = script;
        this.started = started;
        this.result = result;
    }

    public Object getSource() {
        return this.source;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return !this.started;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionEvent that = (ExecutionEvent)o;
        if (this.started != that.started) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (!this.script.equals(that.script)) {
            return false;
        }
        return this.result != null ? this.result.equals(that.result) : that.result == null;
    }

    public int hashCode() {
        int result1 = this.source.hashCode();
        result1 = 31 * result1 + this.script.hashCode();
        result1 = 31 * result1 + (this.started ? 1 : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        return result1;
    }

    public String toString() {
        return "ExecutionEvent{source=" + this.source + ", script='" + this.script + "', started=" + this.started + ", result='" + this.result + "'}";
    }
}

