/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Code;
import com.tagtraum.japlscript.Id;
import com.tagtraum.japlscript.Inherits;
import com.tagtraum.japlscript.JaplEnum;
import com.tagtraum.japlscript.JaplType;
import com.tagtraum.japlscript.Kind;
import com.tagtraum.japlscript.Name;
import com.tagtraum.japlscript.Parameter;
import com.tagtraum.japlscript.Plural;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.Type;
import com.tagtraum.japlscript.Types;
import com.tagtraum.japlscript.generation.AnnotationSignature;
import com.tagtraum.japlscript.generation.ClassSignature;
import com.tagtraum.japlscript.generation.EnumSignature;
import com.tagtraum.japlscript.generation.FieldSignature;
import com.tagtraum.japlscript.generation.MethodSignature;
import com.tagtraum.japlscript.generation.ParameterSignature;
import com.tagtraum.japlscript.types.TypeClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Generator
extends Task {
    private static final String SDEF_DTD = "file://localhost/System/Library/DTDs/sdef.dtd";
    private Path sdef;
    private String packagePrefix = "com.tagtraum.japlscript";
    private Path out = Paths.get(".", new String[0]);
    private final Map<String, String> customTypeMapping = new HashMap<String, String>();
    private final Set<String> excludeClassSet = new HashSet<String>();
    private Map<String, List<Element>> classMap;
    private Map<String, List<Element>> enumerationMap;
    private boolean generateElementSetters = false;

    public boolean isGenerateElementSetters() {
        return this.generateElementSetters;
    }

    public void setGenerateElementSetters(boolean generateElementSetters) {
        boolean oldGenerateElementSetters = this.generateElementSetters;
        this.generateElementSetters = generateElementSetters;
        if (oldGenerateElementSetters != generateElementSetters && generateElementSetters) {
            this.log("You have turned on the generation of element setters. Please note that element setters may not work at all or as expected.", 1);
        }
    }

    public void addConfiguredTypeMapping(TypeMapping typeMapping) {
        this.customTypeMapping.put(typeMapping.getApplescript(), typeMapping.getJava());
    }

    public String getConfiguredTypeMapping(String applescriptType) {
        return this.customTypeMapping.get(applescriptType);
    }

    public void addConfiguredExcludeClass(ExcludeClass excludeClass) {
        this.excludeClassSet.add(excludeClass.getName());
    }

    public boolean isClassExcluded(String classname) {
        return this.excludeClassSet.contains(classname);
    }

    public Path getSdef() {
        return this.sdef;
    }

    public void setSdef(File sdef) {
        this.setSdef(sdef.toPath());
    }

    public void setSdef(Path sdef) {
        this.sdef = sdef;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix.endsWith(".") ? packagePrefix.substring(0, packagePrefix.length() - 1) : packagePrefix;
    }

    public Path getOut() {
        return this.out;
    }

    public void setOut(File out) {
        this.out = out.toPath();
    }

    public void setOut(Path out) {
        this.out = out;
    }

    private String getPackageName() {
        String filename = this.sdef.getFileName().toString();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot != -1) {
            filename = filename.substring(0, lastDot);
        }
        return this.toPackageName(filename);
    }

    public void execute() {
        try {
            this.generate();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void generate() throws ParserConfigurationException, IOException, SAXException {
        this.log("Generating sources...", 2);
        this.log("Sdef: " + this.sdef, 2);
        this.log("Generation output path : " + this.out, 2);
        this.log("Package prefix: " + this.packagePrefix, 2);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (Generator.SDEF_DTD.equals(systemId)) {
                    InputStream sdefDTD = this.getClass().getResourceAsStream("sdef.dtd");
                    assert (sdefDTD != null);
                    return new InputSource(sdefDTD);
                }
                return null;
            }
        });
        Document sdefDocument = documentBuilder.parse(this.sdef.toFile());
        this.buildClassMap(sdefDocument);
        this.buildEnumerationMap(sdefDocument);
        List<ClassSignature> classSignatures = this.createClasses();
        ClassSignature applicationClassSignature = classSignatures.stream().filter(ClassSignature::isApplicationClass).findFirst().orElse(null);
        if (applicationClassSignature != null) {
            String fqcn = classSignatures.stream().map(classSignature -> classSignature.getFullyQualifiedClassName() + ".class").collect(Collectors.joining(", ", Set.class.getName() + "<" + Class.class.getName() + "<?>> APPLICATION_CLASSES = new " + HashSet.class.getName() + "<>(" + Arrays.class.getName() + ".asList(", "))"));
            FieldSignature applicationClasses = new FieldSignature(fqcn, "All classes belonging to this application.");
            applicationClassSignature.add(applicationClasses);
        }
        this.writeClasses(classSignatures);
        this.writeEnumerations(sdefDocument);
    }

    private void writeClasses(List<ClassSignature> classes) throws IOException {
        for (ClassSignature classSignature : classes) {
            Path classFile = this.createClassFile(classSignature.getFullyQualifiedClassName());
            Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(classFile, StandardCharsets.UTF_8, new OpenOption[0]);
            Throwable throwable = null;
            try {
                writer.write(classSignature.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                Generator.$closeResource(throwable, writer);
            }
        }
    }

    private List<ClassSignature> createClasses() {
        ArrayList<ClassSignature> classes = new ArrayList<ClassSignature>();
        for (Map.Entry<String, List<Element>> entry : this.classMap.entrySet()) {
            if (this.isClassExcluded(entry.getKey())) continue;
            ClassSignature classSignature = this.createClass(entry.getValue());
            classes.add(classSignature);
        }
        return classes;
    }

    private void writeEnumerations(Document sdefDocument) throws IOException {
        NodeList enumerations = sdefDocument.getElementsByTagName("enumeration");
        int enumerationsLength = enumerations.getLength();
        for (int j = 0; j < enumerationsLength; ++j) {
            Element enumeration = (Element)enumerations.item(j);
            ClassSignature enumSig = this.createEnumeration(enumeration);
            Path classFile = this.createClassFile(enumSig.getFullyQualifiedClassName());
            Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(classFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(enumSig.toString());
                continue;
            }
        }
    }

    private void buildEnumerationMap(Document sdefDocument) {
        NodeList enumerations = sdefDocument.getElementsByTagName("enumeration");
        int enumerationsLength = enumerations.getLength();
        this.enumerationMap = new HashMap<String, List<Element>>();
        for (int j = 0; j < enumerationsLength; ++j) {
            Element enumeration = (Element)enumerations.item(j);
            String enumerationName = enumeration.getAttribute("name");
            List list = this.enumerationMap.computeIfAbsent(enumerationName, k -> new ArrayList());
            list.add(enumeration);
        }
    }

    private void buildClassMap(Document sdefDocument) {
        this.classMap = new HashMap<String, List<Element>>();
        NodeList classes = sdefDocument.getElementsByTagName("class");
        int classesLength = classes.getLength();
        for (int j = 0; j < classesLength; ++j) {
            Element klass = (Element)classes.item(j);
            String className = klass.getAttribute("name");
            List list = this.classMap.computeIfAbsent(className, k -> new ArrayList());
            list.add(klass);
        }
        NodeList extensions = sdefDocument.getElementsByTagName("class-extension");
        int extensionsLength = extensions.getLength();
        for (int j = 0; j < extensionsLength; ++j) {
            Element klass = (Element)extensions.item(j);
            String className = klass.getAttribute("extends");
            List list = this.classMap.computeIfAbsent(className, k -> new ArrayList());
            list.add(klass);
        }
        NodeList valueTypes = sdefDocument.getElementsByTagName("value-type");
        int valueTypesLength = valueTypes.getLength();
        for (int j = 0; j < valueTypesLength; ++j) {
            Element valueType = (Element)valueTypes.item(j);
            String valueTypeName = valueType.getAttribute("name");
            String standardJavaType = Types.getStandardJavaType(valueTypeName);
            if (standardJavaType != null) continue;
            List list = this.classMap.computeIfAbsent(valueTypeName, k -> new ArrayList());
            list.add(valueType);
        }
        if (this.classMap.isEmpty()) {
            this.log("SDEF does not contain any classes. Adding artificial Application class.", 1);
        }
    }

    private ClassSignature createEnumeration(Element enumeration) {
        String className = enumeration.getAttribute("name");
        String javaClassName = this.getJavaType(className);
        ClassSignature enumSig = new ClassSignature("enum", javaClassName, this.getPackageName(), enumeration.getAttribute("description"));
        enumSig.addImplements(JaplEnum.class.getName());
        enumSig.addImplements(JaplType.class.getName() + "<" + javaClassName + ">");
        if (!Generator.isNullOrEmpty(enumeration.getAttribute("code"))) {
            enumSig.add(new AnnotationSignature(Code.class, "\"" + enumeration.getAttribute("code") + "\""));
        }
        if (!Generator.isNullOrEmpty(className)) {
            enumSig.add(new AnnotationSignature(Name.class, "\"" + className + "\""));
        }
        NodeList enumerators = enumeration.getElementsByTagName("enumerator");
        HashSet<String> enumeratorNames = new HashSet<String>();
        for (int i = 0; i < enumerators.getLength(); ++i) {
            Element enumerator = (Element)enumerators.item(i);
            String name = enumerator.getAttribute("name");
            if (enumeratorNames.contains(name)) {
                this.log("Enumeration " + javaClassName + "/" + className + " contains a duplicate enumerator: " + name, 0);
                continue;
            }
            enumeratorNames.add(name);
            String n = enumerator.getAttribute("name");
            String code = enumerator.getAttribute("code");
            Object description = Generator.isNullOrEmpty(enumerator.getAttribute("description")) ? "null" : "\"" + enumerator.getAttribute("description") + "\"";
            String javaName = Types.toJavaConstant(name);
            enumSig.add(new EnumSignature(javaName, new String[]{"\"" + n + "\"", "\"" + code + "\"", description}));
        }
        enumSig.add(new FieldSignature("private final String name"));
        enumSig.add(new FieldSignature("private final String code"));
        enumSig.add(new FieldSignature("private final String description"));
        MethodSignature constructor = new MethodSignature(javaClassName);
        constructor.setVisibility("private");
        constructor.add(new ParameterSignature("name", "long name", String.class.getName(), new AnnotationSignature[0]));
        constructor.add(new ParameterSignature("code", "AppleScript four-letter code", String.class.getName(), new AnnotationSignature[0]));
        constructor.add(new ParameterSignature("description", "description", String.class.getName(), new AnnotationSignature[0]));
        constructor.setBody("this.name = name;\n    this.code = code;\n    this.description = description;");
        enumSig.add(constructor);
        MethodSignature getName = new MethodSignature("getName");
        getName.setVisibility("public");
        getName.setReturnType(String.class.getName());
        getName.setReturnTypeDescription("long name");
        getName.setBody("return this.name;");
        getName.add(new AnnotationSignature(Override.class, new String[0]));
        enumSig.add(getName);
        MethodSignature getCode = new MethodSignature("getCode");
        getCode.setVisibility("public");
        getCode.setReturnType(String.class.getName());
        getCode.setReturnTypeDescription("AppleScript four-letter code");
        getCode.setBody("return this.code;");
        getCode.add(new AnnotationSignature(Override.class, new String[0]));
        enumSig.add(getCode);
        MethodSignature getDescription = new MethodSignature("getDescription");
        getDescription.setVisibility("public");
        getDescription.setReturnType(String.class.getName());
        getDescription.setReturnTypeDescription("description");
        getDescription.setBody("return this.description;");
        getDescription.add(new AnnotationSignature(Override.class, new String[0]));
        enumSig.add(getDescription);
        MethodSignature _parse = new MethodSignature("_parse");
        _parse.setVisibility("public");
        _parse.add(new ParameterSignature("objectReference", "object reference", String.class.getName(), new AnnotationSignature[0]));
        _parse.add(new ParameterSignature("applicationReference", "application reference", String.class.getName(), new AnnotationSignature[0]));
        _parse.setDescription("Return the correct enum member for a given string/object reference.");
        _parse.setReturnType(javaClassName);
        _parse.setReturnTypeDescription("description");
        StringBuilder parseSB = new StringBuilder();
        for (int i = 0; i < enumerators.getLength(); ++i) {
            Element enumerator = (Element)enumerators.item(i);
            String name = enumerator.getAttribute("name");
            String code = enumerator.getAttribute("code");
            String javaName = Types.toJavaConstant(name);
            if (i != 0) {
                parseSB.append("    else ");
            }
            parseSB.append("if (\"" + code + "\".equals(objectReference) || \"" + name + "\".equals(objectReference) || \"\u00abconstant ****" + code + "\u00bb\".equals(objectReference)) return " + javaName + ";\n");
        }
        parseSB.append("    else throw new ").append(IllegalArgumentException.class.getName()).append("(\"Enum \" + name + \" is unknown.\");");
        _parse.setBody(parseSB.toString());
        _parse.add(new AnnotationSignature(Override.class, new String[0]));
        enumSig.add(_parse);
        MethodSignature _encode = new MethodSignature("_encode");
        _encode.setVisibility("public");
        _encode.setReturnType(String.class.getName());
        _encode.setReturnTypeDescription("Encode enum as AppleScript string");
        _encode.add(new ParameterSignature("japlEnum", JaplEnum.class.getSimpleName() + " instance", Object.class.getName(), new AnnotationSignature[0]));
        _encode.setBody("return ((" + JaplEnum.class.getName() + ")japlEnum).getName();");
        _encode.add(new AnnotationSignature(Override.class, new String[0]));
        enumSig.add(_encode);
        MethodSignature _getInterfaceType = new MethodSignature("_getInterfaceType");
        _getInterfaceType.setVisibility("public");
        _getInterfaceType.setReturnType("java.lang.Class<" + javaClassName + ">");
        _getInterfaceType.setReturnTypeDescription("Encode enum as AppleScript string");
        _getInterfaceType.setBody("return " + javaClassName + ".class;");
        _getInterfaceType.add(new AnnotationSignature(Override.class, new String[0]));
        enumSig.add(_getInterfaceType);
        return enumSig;
    }

    private ClassSignature createClass(List<Element> classList) {
        Element klass = classList.get(0);
        String className = klass.getAttribute("name") != null && !klass.getAttribute("name").isEmpty() ? klass.getAttribute("name") : klass.getAttribute("extends");
        String javaClassName = Types.toCamelCaseClassName(className);
        ClassSignature classSignature = new ClassSignature("interface", javaClassName, this.getPackageName(), Generator.toJavadocDescription(klass.getAttribute("description")));
        Object code = "null";
        String typeSuperClass = null;
        String superClass = klass.getAttribute("inherits");
        if (!Generator.isNullOrEmpty(klass.getAttribute("plural"))) {
            classSignature.add(new AnnotationSignature(Plural.class, "\"" + klass.getAttribute("plural") + "\""));
        }
        if (!Generator.isNullOrEmpty(klass.getAttribute("code"))) {
            code = "\"\\u00abclass " + klass.getAttribute("code") + "\\u00bb\"";
        }
        classSignature.add(new AnnotationSignature(Code.class, "\"" + klass.getAttribute("code") + "\""));
        if (!Generator.isNullOrEmpty(className)) {
            classSignature.add(new AnnotationSignature(Name.class, "\"" + className + "\""));
        }
        if (!Generator.isNullOrEmpty(superClass)) {
            classSignature.add(new AnnotationSignature(Inherits.class, "\"" + superClass + "\""));
        }
        classSignature.addExtends(Reference.class.getName());
        if (!Generator.isNullOrEmpty(superClass) && !superClass.equals(className)) {
            String additionalSuperClass = this.getJavaType(superClass);
            if (!Reference.class.getName().equals(additionalSuperClass)) {
                classSignature.addExtends(additionalSuperClass);
                typeSuperClass = additionalSuperClass + ".CLASS";
            }
        }
        String typeClassField = TypeClass.class.getName() + " CLASS = " + TypeClass.class.getName() + ".getInstance(\"" + className + "\", " + (String)code + ", null, " + typeSuperClass + ")";
        classSignature.add(new FieldSignature(typeClassField, null));
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        if (classSignature.isApplicationClass()) {
            methods.addAll(this.createAllCommandMethods(klass.getOwnerDocument()));
        }
        for (Element classElement : classList) {
            NodeList elements = classElement.getElementsByTagName("element");
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element = (Element)elements.item(i);
                methods.addAll(this.createElementMethods(element));
            }
            NodeList properties = classElement.getElementsByTagName("property");
            for (int i = 0; i < properties.getLength(); ++i) {
                Element property = (Element)properties.item(i);
                methods.addAll(this.createPropertyMethods(property, true));
            }
        }
        methods.add(this.createPropertiesMethod());
        for (MethodSignature method : methods) {
            if (!classSignature.contains(method)) {
                classSignature.add(method);
                continue;
            }
            this.log("Skipping " + method + " because it is already declared.");
        }
        return classSignature;
    }

    private MethodSignature createPropertiesMethod() {
        MethodSignature methodSignature = new MethodSignature("getProperties");
        methodSignature.setReturnTypeDescription("Map containing all properties");
        methodSignature.setReturnType(Map.class.getName() + "<String, Object>");
        methodSignature.setDescription("Returns all properties for an instance of this class.");
        return methodSignature;
    }

    private List<MethodSignature> createAllCommandMethods(Document document) {
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        NodeList commands = document.getElementsByTagName("command");
        for (int i = 0; i < commands.getLength(); ++i) {
            Element command = (Element)commands.item(i);
            methods.addAll(this.createCommandMethod(command));
        }
        return methods;
    }

    private List<MethodSignature> createCommandMethod(Element command) {
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        String name = command.getAttribute("name");
        String description = command.getAttribute("description");
        int overloadedVersions = this.getOverloadCount(command);
        for (int overloadCount = 0; overloadCount < overloadedVersions; ++overloadCount) {
            ArrayList<ParameterSignature> parameterSignatures = new ArrayList<ParameterSignature>();
            HashSet<String> alreadyUsedJavaParameterNames = new HashSet<String>();
            String returnType = "void";
            String returnTypeDescription = null;
            NodeList children = command.getChildNodes();
            block11: for (int i = 0; i < children.getLength(); ++i) {
                Element element;
                Node child = children.item(i);
                if (!(child instanceof Element) || "access-group".equals((element = (Element)child).getTagName()) || "cocoa".equals(element.getTagName()) || "synonym".equals(element.getTagName())) continue;
                String parameterType = this.getParameterBaseType(element, overloadCount);
                boolean array = this.isParameterArray(element, overloadCount);
                String parameterDescription = element.getAttribute("description");
                String javaParameterName = Generator.getParameterName(alreadyUsedJavaParameterNames, parameterDescription, parameterType, array);
                alreadyUsedJavaParameterNames.add(javaParameterName);
                switch (element.getTagName()) {
                    case "direct-parameter": {
                        ParameterSignature param = new ParameterSignature(javaParameterName, parameterDescription, this.getJavaType(parameterType, array), new AnnotationSignature[0]);
                        parameterSignatures.add(param);
                        continue block11;
                    }
                    case "parameter": {
                        String parameterName = element.getAttribute("name");
                        AnnotationSignature annotationSignature = new AnnotationSignature(Parameter.class, "\"" + parameterName + "\"");
                        ParameterSignature param = new ParameterSignature(javaParameterName, parameterDescription, this.getJavaType(parameterType, array), annotationSignature);
                        parameterSignatures.add(param);
                        continue block11;
                    }
                    case "result": {
                        returnTypeDescription = parameterDescription;
                        returnType = this.getJavaType(parameterType, array);
                    }
                }
            }
            String methodName = Types.toCamelCaseMethodName(name);
            MethodSignature commandSignature = new MethodSignature(methodName);
            commandSignature.setDescription(Generator.toJavadocDescription(description));
            commandSignature.setReturnType(returnType);
            commandSignature.setReturnTypeDescription(returnTypeDescription);
            for (ParameterSignature param : parameterSignatures) {
                commandSignature.add(param);
            }
            commandSignature.add(new AnnotationSignature(Kind.class, "\"command\""));
            commandSignature.add(new AnnotationSignature(Name.class, "\"" + name + "\""));
            methods.add(commandSignature);
        }
        if ("make".equals(name)) {
            MethodSignature specialMake = new MethodSignature("make");
            specialMake.setDescription(Generator.toJavadocDescription(description));
            specialMake.setReturnType("<T extends " + Reference.class.getName() + "> T");
            specialMake.setReturnTypeDescription("a new object of type klass");
            specialMake.add(new ParameterSignature("klass", "Java type of the object to create.", "java.lang.Class<T>", new AnnotationSignature[0]));
            specialMake.add(new AnnotationSignature(Kind.class, "\"make\""));
            methods.add(specialMake);
        }
        return methods;
    }

    private String getParameterBaseType(Element element, int overloadCount) {
        String parameterType = element.getAttribute("type");
        if (parameterType == null || parameterType.length() == 0) {
            NodeList types = element.getElementsByTagName("type");
            Element typeElement = (Element)types.item(overloadCount);
            parameterType = typeElement.getAttribute("type");
        }
        return parameterType;
    }

    private boolean isParameterArray(Element element, int overloadCount) {
        boolean array = false;
        String parameterType = element.getAttribute("type");
        if (parameterType == null || parameterType.length() == 0) {
            NodeList types = element.getElementsByTagName("type");
            Element typeElement = (Element)types.item(overloadCount);
            array = "yes".equals(typeElement.getAttribute("list"));
        }
        return array;
    }

    private int getOverloadCount(Element command) {
        int overloadedVersions = 1;
        NodeList c = command.getChildNodes();
        for (int j = 0; j < c.getLength(); ++j) {
            NodeList types;
            Element element;
            Node child = c.item(j);
            if (!(child instanceof Element) || !"direct-parameter".equals((element = (Element)child).getTagName()) || (types = element.getElementsByTagName("type")).getLength() <= 0) continue;
            overloadedVersions = types.getLength();
        }
        return overloadedVersions;
    }

    private static String getParameterName(Collection<String> usedNames, String description, String type, boolean isArray) {
        Object newName;
        if (description != null && !description.isEmpty()) {
            String newBaseName = Types.toCamelCaseMethodName(description);
            newName = newBaseName;
            int i = 0;
            while (usedNames.contains(newName)) {
                newName = newBaseName + i;
                ++i;
            }
        } else {
            Object newBaseName = Types.toCamelCaseMethodName(type);
            if (isArray) {
                newBaseName = (String)newBaseName + "s";
            }
            newName = newBaseName;
            int i = 0;
            while (usedNames.contains(newName)) {
                newName = (String)newBaseName + i;
                ++i;
            }
        }
        return newName;
    }

    private List<MethodSignature> createElementMethods(Element element) {
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        String type = element.getAttribute("type");
        String javaClassName = this.getJavaType(type);
        String propertyName = Types.toCamelCaseClassName(type);
        String access = Generator.isNullOrEmpty(element.getAttribute("access")) ? "rw" : element.getAttribute("access");
        String description = element.getAttribute("description");
        if (this.generateElementSetters && access.indexOf(119) != -1) {
            MethodSignature setter = new MethodSignature("set" + propertyName);
            setter.setDescription(Generator.toJavadocDescription(description));
            setter.setReturnType("void");
            setter.setReturnTypeDescription(null);
            setter.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                setter.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            setter.add(new ParameterSignature("index", "index into the element list", "int", new AnnotationSignature[0]));
            setter.add(new ParameterSignature("value", "element to set in the list", javaClassName, new AnnotationSignature[0]));
            methods.add(setter);
        }
        if (access.indexOf(114) != -1) {
            MethodSignature getterNoFilter = new MethodSignature("get" + propertyName + "s");
            getterNoFilter.setDescription(Generator.toJavadocDescription(description));
            getterNoFilter.setReturnType(javaClassName + "[]");
            getterNoFilter.setReturnTypeDescription("an array of all {@link " + javaClassName + "}s");
            getterNoFilter.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                getterNoFilter.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            getterNoFilter.setBody("return get" + propertyName + "s(null);");
            getterNoFilter.setDefaultMethod(true);
            methods.add(getterNoFilter);
            MethodSignature getter = new MethodSignature("get" + propertyName + "s");
            getter.setDescription(Generator.toJavadocDescription(description));
            getter.setReturnType(javaClassName + "[]");
            getter.setReturnTypeDescription("an array of all {@link " + javaClassName + "}s");
            getter.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                getter.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            getter.add(new ParameterSignature("filter", "AppleScript filter clause without the leading \"whose\" or \"where\"", String.class.getName(), new AnnotationSignature[0]));
            methods.add(getter);
            MethodSignature getterWithIndex = new MethodSignature("get" + propertyName);
            getterWithIndex.setDescription(Generator.toJavadocDescription(description));
            getterWithIndex.setReturnType(javaClassName);
            getterWithIndex.setReturnTypeDescription("the {@link " + javaClassName + "} at the requested index");
            getterWithIndex.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                getterWithIndex.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            getterWithIndex.add(new ParameterSignature("index", "index into the element list", "int", new AnnotationSignature[0]));
            methods.add(getterWithIndex);
            MethodSignature getterWithId = new MethodSignature("get" + propertyName);
            getterWithId.setDescription(Generator.toJavadocDescription(description));
            getterWithId.setReturnType(javaClassName);
            getterWithId.setReturnTypeDescription("the {@link " + javaClassName + "} with the requested id");
            getterWithId.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                getterWithId.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            getterWithId.add(new ParameterSignature("id", "id of the item", Id.class.getName(), new AnnotationSignature[0]));
            methods.add(getterWithId);
            MethodSignature countNoFilter = new MethodSignature("count" + propertyName + "s");
            countNoFilter.setDescription(Generator.toJavadocDescription(description));
            countNoFilter.setReturnType("int");
            countNoFilter.setReturnTypeDescription("number of all {@link " + javaClassName + "}s");
            countNoFilter.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                countNoFilter.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            countNoFilter.setBody("return count" + propertyName + "s(null);");
            countNoFilter.setDefaultMethod(true);
            methods.add(countNoFilter);
            MethodSignature count = new MethodSignature("count" + propertyName + "s");
            count.setDescription(Generator.toJavadocDescription(description));
            count.setReturnType("int");
            count.setReturnTypeDescription("the number of elements that pass the filter");
            count.add(new AnnotationSignature(Kind.class, "\"element\""));
            if (!Generator.isNullOrEmpty(type)) {
                count.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            count.add(new ParameterSignature("filter", "AppleScript filter clause without the leading \"whose\" or \"where\"", String.class.getName(), new AnnotationSignature[0]));
            methods.add(count);
        }
        return methods;
    }

    private List<MethodSignature> createPropertyMethods(Element property, boolean skipProperties) {
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        String name = property.getAttribute("name");
        if (skipProperties && "properties".equals(name)) {
            return methods;
        }
        String type = property.getAttribute("type");
        boolean isArray = false;
        if (type == null || type.isEmpty()) {
            type = null;
            NodeList types = property.getElementsByTagName("type");
            for (int i = 0; i < types.getLength(); ++i) {
                Element typeElement = (Element)types.item(i);
                String t = typeElement.getAttribute("type");
                if ("missing value".equals(t)) continue;
                if (type != null) {
                    throw new RuntimeException("Cannot generate code for properties with multiple (non-null/missing value) types. Property: " + name);
                }
                type = t;
                isArray = "yes".equals(typeElement.getAttribute("list"));
            }
            if (types.getLength() == 1) {
                Element typeElement = (Element)types.item(0);
                type = typeElement.getAttribute("type");
                isArray = "yes".equals(typeElement.getAttribute("list"));
            }
        }
        String code = property.getAttribute("code");
        String array = isArray ? "[]" : "";
        String javaClassName = this.getJavaType(type) + array;
        String javaPropertyName = this.avoidForbiddenMethodNames(Types.toCamelCaseClassName(name));
        String access = Generator.isNullOrEmpty(property.getAttribute("access")) ? "rw" : property.getAttribute("access");
        String description = property.getAttribute("description");
        if (access.indexOf(114) != -1) {
            MethodSignature getter = new MethodSignature("get" + javaPropertyName);
            getter.setDescription(Generator.toJavadocDescription(description));
            getter.setReturnType(javaClassName);
            getter.setReturnTypeDescription("Property value");
            getter.add(new AnnotationSignature(Kind.class, "\"property\""));
            if (!Generator.isNullOrEmpty(type)) {
                getter.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            if (!Generator.isNullOrEmpty(name)) {
                getter.add(new AnnotationSignature(Name.class, "\"" + name + "\""));
            }
            if (!Generator.isNullOrEmpty(code)) {
                getter.add(new AnnotationSignature(Code.class, "\"" + code + "\""));
            }
            methods.add(getter);
        }
        if (access.indexOf(119) != -1) {
            MethodSignature setter = new MethodSignature("set" + javaPropertyName);
            setter.setDescription(Generator.toJavadocDescription(description));
            setter.setReturnType("void");
            setter.setReturnTypeDescription(null);
            setter.add(new AnnotationSignature(Kind.class, "\"property\""));
            if (!Generator.isNullOrEmpty(type)) {
                setter.add(new AnnotationSignature(Type.class, "\"" + type + "\""));
            }
            if (!Generator.isNullOrEmpty(name)) {
                setter.add(new AnnotationSignature(Name.class, "\"" + name + "\""));
            }
            if (!Generator.isNullOrEmpty(code)) {
                setter.add(new AnnotationSignature(Code.class, "\"" + code + "\""));
            }
            setter.add(new ParameterSignature("object", "new property value", javaClassName, new AnnotationSignature[0]));
            methods.add(setter);
        }
        return methods;
    }

    private String avoidForbiddenMethodNames(String name) {
        if ("Class".equals(name)) {
            return "Klass";
        }
        return name;
    }

    private Path createClassFile(String className) {
        return this.out.resolve(Generator.classToFile(className));
    }

    private String toPackageName(String sdefName) {
        return this.packagePrefix + "." + Generator.sdefNameToPackageName(sdefName);
    }

    private String getJavaType(String applescriptType) {
        return this.getJavaType(applescriptType, false);
    }

    private String getJavaType(String applescriptType, boolean array) {
        String javaType = this.customTypeMapping.get(applescriptType);
        if (javaType == null) {
            if (this.classMap.containsKey(applescriptType)) {
                javaType = Types.toCamelCaseClassName(applescriptType);
            } else if (this.enumerationMap.containsKey(applescriptType)) {
                javaType = Types.toCamelCaseClassName(applescriptType);
            }
        }
        if (javaType == null) {
            javaType = Types.getStandardJavaType(applescriptType);
        }
        if (javaType == null) {
            this.log("Warning: Unable to resolve Applescript class '" + applescriptType + "'. Will use plain Reference instead.");
            javaType = Reference.class.getName();
        }
        return array ? javaType + "[]" : javaType;
    }

    private static String sdefNameToPackageName(String suiteName) {
        return suiteName.toLowerCase().replace(' ', '_');
    }

    private static String classToFile(String packageName) {
        return packageName.replace('.', '/') + ".java";
    }

    private static String toJavadocDescription(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        sb.append(Character.toUpperCase(s.charAt(0)));
        sb.append(s.substring(1));
        if (!(s.endsWith(".") || s.endsWith("?") || s.endsWith("!"))) {
            sb.append('.');
        }
        return sb.toString();
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        Generator generator = new Generator();
        generator.setSdef(new File(args[0]).toPath());
        generator.setOut(Paths.get("out", new String[0]));
        generator.generate();
    }

    public static class ExcludeClass {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class TypeMapping {
        private String applescript;
        private String java;

        public String getApplescript() {
            return this.applescript;
        }

        public void setApplescript(String applescript) {
            this.applescript = applescript;
        }

        public String getJava() {
            return this.java;
        }

        public void setJava(String java) {
            this.java = java;
        }
    }
}

