/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Aspect;
import com.tagtraum.japlscript.JaplEnum;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.JaplType;
import com.tagtraum.japlscript.ObjectInvocationHandler;
import com.tagtraum.japlscript.Property;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.Session;
import com.tagtraum.japlscript.types.Alias;
import com.tagtraum.japlscript.types.Boolean;
import com.tagtraum.japlscript.types.Data;
import com.tagtraum.japlscript.types.Date;
import com.tagtraum.japlscript.types.Double;
import com.tagtraum.japlscript.types.Float;
import com.tagtraum.japlscript.types.Integer;
import com.tagtraum.japlscript.types.JaplScriptFile;
import com.tagtraum.japlscript.types.Long;
import com.tagtraum.japlscript.types.Picture;
import com.tagtraum.japlscript.types.Point;
import com.tagtraum.japlscript.types.RGBColor;
import com.tagtraum.japlscript.types.Record;
import com.tagtraum.japlscript.types.Rectangle;
import com.tagtraum.japlscript.types.ReferenceImpl;
import com.tagtraum.japlscript.types.Tdta;
import com.tagtraum.japlscript.types.Text;
import com.tagtraum.japlscript.types.TypeClass;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class JaplScript {
    private static final Logger LOG = Logger.getLogger(JaplScript.class.getName());
    private static final int LAST_ASCII_CHAR = 127;
    private static final List<JaplType<?>> types = new ArrayList();
    private static final List<Aspect> globalAspects = new ArrayList<Aspect>();
    private static final Map<String, Class<?>> applicationInterfaces = new HashMap();
    private static final Map<Class<?>, Map<String, Property>> applicationProperties = new HashMap();

    private static void addDefaultTypes() {
        JaplScript.addType(Text.getInstance());
        JaplScript.addType(Integer.getInstance());
        JaplScript.addType(Long.getInstance());
        JaplScript.addType(Float.getInstance());
        JaplScript.addType(Double.getInstance());
        JaplScript.addType(Boolean.getInstance());
        JaplScript.addType(Date.getInstance());
        JaplScript.addType(Alias.getInstance());
        JaplScript.addType(Data.getInstance());
        JaplScript.addType(Picture.getInstance());
        JaplScript.addType(Tdta.getInstance());
        JaplScript.addType(JaplScriptFile.getInstance());
        JaplScript.addType(Point.getInstance());
        JaplScript.addType(Rectangle.getInstance());
        JaplScript.addType(RGBColor.getInstance());
        JaplScript.addType(TypeClass.getInstance());
        JaplScript.addType(Record.getInstance());
        JaplScript.addType(ReferenceImpl.getInstance());
    }

    private static void addDefaultGlobalAspects() {
        JaplScript.addGlobalAspect(new DateHelper());
        JaplScript.addGlobalAspect(new Tell());
    }

    private JaplScript() {
    }

    public static void addGlobalAspect(Aspect aspect) {
        globalAspects.add(aspect);
    }

    public static boolean removeGlobalAspect(Aspect aspect) {
        return globalAspects.remove(aspect);
    }

    public static List<Aspect> getGlobalAspects() {
        return new ArrayList<Aspect>(globalAspects);
    }

    public static void addType(JaplType<?> type) {
        types.add(type);
    }

    public static boolean removeType(JaplType<?> type) {
        return types.remove(type);
    }

    public static List<JaplType<?>> getTypes() {
        return new ArrayList(types);
    }

    public static Session startSession() {
        Session session = Session.getSession();
        if (session == null) {
            session = new Session();
        }
        return session;
    }

    public static <T> T getApplication(Class<T> interfaceClass, String applicationName) {
        ReferenceImpl reference = new ReferenceImpl(null, "application \"" + applicationName + "\"");
        JaplScript.registerApplicationInterface(interfaceClass, reference);
        JaplScript.registerApplicationProperties(interfaceClass);
        return JaplScript.cast(interfaceClass, reference);
    }

    private static <T> void registerApplicationInterface(Class<T> interfaceClass, Reference reference) {
        applicationInterfaces.put(reference.getApplicationReference(), interfaceClass);
    }

    private static Class<?> getApplicationInterface(Reference reference) {
        return applicationInterfaces.get(reference.getApplicationReference());
    }

    public static Property getProperty(Reference reference, String name) {
        Class<?> applicationInterface = JaplScript.getApplicationInterface(reference);
        return applicationProperties.get(applicationInterface).get(name);
    }

    private static void registerApplicationProperties(Class<?> applicationInterface) {
        HashMap<Object, Property> allProperties = new HashMap<Object, Property>();
        try {
            Field applicationClassesField = applicationInterface.getField("APPLICATION_CLASSES");
            Set applicationClasses = (Set)applicationClassesField.get(null);
            for (Class klass : applicationClasses) {
                Set<Property> properties = Property.fromAnnotations(klass);
                for (Property property : properties) {
                    Property previousByCode;
                    Property previousByName;
                    if (!property.equals(previousByName = allProperties.put(property.getName(), property))) {
                        LOG.warning("The property " + previousByName + " was replaced in the application-wide property map for the name key \"" + property.getName() + "\"");
                    }
                    if (property.equals(previousByCode = allProperties.put("\u00abproperty " + property.getCode() + "\u00bb", property))) continue;
                    LOG.warning("The property " + previousByCode + " was replaced in the application-wide property map for the code key \u00abproperty " + property.getCode() + "\u00bb");
                }
            }
            applicationProperties.put(applicationInterface, allProperties);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new JaplScriptException("Failure while registering application-wide properties", e);
        }
    }

    public static <T> T cast(Class<T> interfaceClass, Reference reference) {
        if (reference == null) {
            return null;
        }
        try {
            String objectReference = reference.getObjectReference();
            for (JaplType<?> type : types) {
                if (interfaceClass != type._getInterfaceType()) continue;
                return (T)type._parse(reference);
            }
            if (interfaceClass.isArray()) {
                if (objectReference == null) {
                    return null;
                }
                return (T)JaplScript.parseList(interfaceClass.getComponentType(), reference);
            }
            if (interfaceClass.equals(Map.class)) {
                if (objectReference == null) {
                    return (T)Collections.emptyMap();
                }
                return (T)JaplScript.parseRecord(reference);
            }
            if (objectReference != null && objectReference.trim().length() == 0) {
                return null;
            }
            if (JaplEnum.class.isAssignableFrom(interfaceClass) && JaplType.class.isAssignableFrom(interfaceClass)) {
                T firstConstant = interfaceClass.getEnumConstants()[0];
                return ((JaplType)firstConstant)._parse(reference);
            }
            if (!interfaceClass.isInterface()) {
                throw new JaplScriptException("Cannot create proxy for non-interface class " + interfaceClass);
            }
            return (T)Proxy.newProxyInstance(JaplScript.class.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ObjectInvocationHandler(reference));
        }
        catch (JaplScriptException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JaplScriptException("Failed to cast " + reference + " to " + interfaceClass, e);
        }
    }

    private static <T> T[] parseList(Class<T> interfaceClass, Reference reference) {
        String objectReference = reference.getObjectReference();
        String applicationReference = reference.getApplicationReference();
        ArrayList<T> result = new ArrayList<T>();
        int depth = 0;
        boolean quotes = false;
        boolean curlies = objectReference.startsWith("{");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectReference.length(); ++i) {
            boolean lastChar;
            char c = objectReference.charAt(i);
            char previousChar = i == 0 ? (char)'\u0000' : objectReference.charAt(i - 1);
            switch (c) {
                case '\"': {
                    if (previousChar == '\\') break;
                    quotes = !quotes;
                    break;
                }
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    --depth;
                    break;
                }
            }
            boolean bl = lastChar = i == objectReference.length() - 1;
            if (quotes) {
                sb.append(c);
                continue;
            }
            if (depth == 1 && c == ',' || depth == 0 && c == '}' || !curlies && (c == ',' || lastChar)) {
                if (!curlies && lastChar) {
                    sb.append(c);
                }
                if (sb.length() <= 0) continue;
                result.add(JaplScript.cast(interfaceClass, new ReferenceImpl(sb.toString(), applicationReference)));
                sb.setLength(0);
                continue;
            }
            if (depth == 1 && c != '{') {
                sb.append(c);
                continue;
            }
            if (!curlies) {
                sb.append(c);
                continue;
            }
            if (depth <= 1) continue;
            sb.append(c);
        }
        return result.toArray((Object[])Array.newInstance(interfaceClass, result.size()));
    }

    private static Map<String, Reference> parseRecord(Reference reference) {
        String objectReference = reference.getObjectReference();
        String applicationReference = reference.getApplicationReference();
        HashMap<String, Reference> result = new HashMap<String, Reference>();
        int depth = 0;
        boolean quotes = false;
        boolean curlies = objectReference.startsWith("{");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectReference.length(); ++i) {
            char c = objectReference.charAt(i);
            char previousChar = i == 0 ? (char)'\u0000' : objectReference.charAt(i - 1);
            boolean isLastChar = i == objectReference.length() - 1;
            switch (c) {
                case '\"': {
                    if (previousChar == '\\') break;
                    quotes = !quotes;
                    break;
                }
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    --depth;
                    break;
                }
            }
            if (quotes) {
                sb.append(c);
                continue;
            }
            if (depth == 1 && c == ',' || depth == 0 && c == '}' || !curlies && (c == ',' || isLastChar)) {
                if (!curlies && isLastChar) {
                    sb.append(c);
                }
                if (sb.length() <= 0) continue;
                int afterKey = sb.indexOf(":");
                String key = sb.substring(0, afterKey).trim();
                String value = sb.substring(afterKey + 1).trim();
                result.put(key, new ReferenceImpl(value, applicationReference));
                sb.setLength(0);
                continue;
            }
            if (depth == 1 && c != '{') {
                sb.append(c);
                continue;
            }
            if (!curlies) {
                sb.append(c);
                continue;
            }
            if (depth <= 1) continue;
            sb.append(c);
        }
        return result;
    }

    public static String asUnicodeText(String s) {
        byte[] buf;
        StringBuilder sb = new StringBuilder();
        sb.append("(\u00abdata utf8");
        for (byte b : buf = s.getBytes(StandardCharsets.UTF_8)) {
            int i = b & 0xFF;
            String hex = java.lang.Integer.toHexString(i);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        sb.append("\u00bb as Unicode text)");
        return sb.toString();
    }

    public static String quote(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append("(\"");
        int unicodeStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (unicodeStart != -1) continue;
                unicodeStart = i;
                continue;
            }
            if (unicodeStart != -1) {
                sb.append("\" & ");
                sb.append(JaplScript.asUnicodeText(s.substring(unicodeStart, i)));
                sb.append(" & \"");
                unicodeStart = -1;
            }
            switch (c) {
                case '\"': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        if (unicodeStart != -1) {
            sb.append("\" & ");
            sb.append(JaplScript.asUnicodeText(s.substring(unicodeStart)));
            sb.append(")");
        } else {
            sb.append("\")");
        }
        return sb.toString();
    }

    static {
        JaplScript.addDefaultGlobalAspects();
        JaplScript.addDefaultTypes();
    }

    private static class DateHelper
    implements Aspect {
        private DateHelper() {
        }

        @Override
        public String before(String application, String body) {
            return null;
        }

        @Override
        public String after(String application, String body) {
            if (body.contains("my createDate")) {
                return "on createDate(y, m, d, h, min, s)\n\tset dateVar to (current date)\n\tset year of dateVar to y\n\tset month of dateVar to m\n\tset day of dateVar to d\n\tset hours of dateVar to h\n\tset minutes of dateVar to min\n\tset seconds of dateVar to s\n\treturn dateVar\nend createDate";
            }
            return null;
        }
    }

    private static class Tell
    implements Aspect {
        private Tell() {
        }

        @Override
        public String before(String application, String body) {
            if (application != null) {
                return "tell " + application;
            }
            return "";
        }

        @Override
        public String after(String application, String body) {
            if (application != null) {
                return "end tell";
            }
            return "";
        }
    }
}

