/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Aspect;
import com.tagtraum.japlscript.Id;
import com.tagtraum.japlscript.JaplEnum;
import com.tagtraum.japlscript.JaplScript;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.JaplType;
import com.tagtraum.japlscript.Kind;
import com.tagtraum.japlscript.Name;
import com.tagtraum.japlscript.Parameter;
import com.tagtraum.japlscript.Plural;
import com.tagtraum.japlscript.Property;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.ScriptExecutor;
import com.tagtraum.japlscript.Session;
import com.tagtraum.japlscript.Type;
import com.tagtraum.japlscript.types.Record;
import com.tagtraum.japlscript.types.ReferenceImpl;
import com.tagtraum.japlscript.types.TypeClass;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ObjectInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(ObjectInvocationHandler.class.getName());
    private static final Method TO_STRING_METHOD;
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method OBJECT_REFERENCE_METHOD;
    private static final Method APPLICATION_REFERENCE_METHOD;
    private static final Method CAST_METHOD;
    private static final Method IS_INSTANCE_OF_METHOD;
    private final Reference reference;
    private boolean reduceScriptExecutions = true;

    public ObjectInvocationHandler(Reference reference) {
        this.reference = reference;
    }

    public boolean isReduceScriptExecutions() {
        return this.reduceScriptExecutions;
    }

    public void setReduceScriptExecutions(boolean reduceScriptExecutions) {
        this.reduceScriptExecutions = reduceScriptExecutions;
    }

    public TypeClass getTypeClass() {
        try {
            return this.executeAppleScript(this.reference, "return class of " + this.reference.getObjectReference(), TypeClass.class);
        }
        catch (IOException e) {
            throw new JaplScriptException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            Object returnValue = null;
            if (TO_STRING_METHOD.equals(method)) {
                return this.toString(this.reference);
            }
            if (OBJECT_REFERENCE_METHOD.equals(method)) {
                return this.reference.getObjectReference();
            }
            if (EQUALS_METHOD.equals(method)) {
                return this.equals(this.reference, args[0]);
            }
            if (HASHCODE_METHOD.equals(method)) {
                return this.reference.hashCode();
            }
            if (APPLICATION_REFERENCE_METHOD.equals(method)) {
                return this.reference.getApplicationReference();
            }
            if (CAST_METHOD.equals(method)) {
                return JaplScript.cast((Class)args[0], this.reference);
            }
            if (IS_INSTANCE_OF_METHOD.equals(method)) {
                return args.length == 1 && args[0] != null && ((TypeClass)args[0]).isInstance(this.reference);
            }
            if ("getProperties".equals(method.getName()) && (args == null || args.length == 0)) {
                return this.invokeProperties();
            }
            Kind kind = method.getAnnotation(Kind.class);
            if ("element".equals(kind.value())) {
                returnValue = this.invokeElement(method, method.getReturnType(), args);
            } else if ("property".equals(kind.value())) {
                returnValue = this.invokeProperty(method, method.getReturnType(), args);
            } else if ("command".equals(kind.value())) {
                returnValue = this.invokeCommand(method, method.getReturnType(), args);
            } else if ("make".equals(kind.value())) {
                returnValue = this.invokeMake(method, args);
            }
            return returnValue;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new JaplScriptException(e);
        }
    }

    private Map<String, Object> invokeProperties() throws IOException {
        Record properties = this.executeAppleScript(this.reference, "return properties" + this.getOfClause(), Record.class);
        Map stringReferenceMap = JaplScript.cast(Map.class, properties);
        HashMap<String, Object> javaMap = new HashMap<String, Object>();
        for (Map.Entry e : stringReferenceMap.entrySet()) {
            String propertyName = (String)e.getKey();
            Reference propertyValue = (Reference)e.getValue();
            Property property = JaplScript.getProperty(this.reference, propertyName);
            if (property != null) {
                javaMap.put(property.getJavaName(), JaplScript.cast(property.getJavaClass(), propertyValue));
                continue;
            }
            LOG.warning("Failed to translate AppleScript property named \"" + propertyName + "\" to Java.");
            javaMap.put(propertyName, propertyValue);
        }
        return javaMap;
    }

    private String toString(Reference reference) {
        return "[" + reference.getApplicationReference() + "]: " + reference.getObjectReference();
    }

    private boolean equals(Reference ref1, Object ref2) {
        if (ref2 == null) {
            return false;
        }
        if (!(ref2 instanceof Reference)) {
            return false;
        }
        return this.toString(ref1).equals(this.toString((Reference)ref2));
    }

    private <T> T invokeMake(Method method, Object ... args) throws IOException {
        if (args.length != 1) {
            throw new JaplScriptException("Wrong number of arguments for " + method + ": " + args.length);
        }
        if (!(args[0] instanceof Class)) {
            throw new JaplScriptException("Argument is not a class object: " + args[0].getClass());
        }
        Class klass = (Class)args[0];
        Name applescriptClassname = klass.getAnnotation(Name.class);
        if (applescriptClassname == null) {
            throw new IOException("\"make\" failed, because we failed to find a Name annotation for class " + klass);
        }
        String applescript = "make " + applescriptClassname.value();
        return this.executeAppleScript(this.reference, applescript, klass);
    }

    private <T> T invokeCommand(Method method, Class<T> returnType, Object ... args) throws IOException {
        Name name = method.getAnnotation(Name.class);
        Parameter[] parameters = ObjectInvocationHandler.getFirstParameterAnnotations(method);
        StringBuilder applescript = new StringBuilder(name.value() + " ");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                if (parameters[i] != null) {
                    applescript.append(parameters[i].value());
                }
                applescript.append(' ');
                applescript.append(this.encode(arg));
                applescript.append(" ");
            }
        }
        return this.executeAppleScript(this.reference, applescript.toString(), returnType);
    }

    private static Parameter[] getFirstParameterAnnotations(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Parameter[] parameters = new Parameter[parameterAnnotations.length];
        int j = 0;
        for (Annotation[] anns : parameterAnnotations) {
            if (anns.length > 0) {
                parameters[j] = (Parameter)anns[0];
            }
            ++j;
        }
        return parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T invokeElement(Method method, Class<T> returnType, Object ... args) throws IOException, NoSuchMethodException {
        T returnValue = null;
        Type type = method.getAnnotation(Type.class);
        if (method.getName().startsWith("get")) {
            if (method.getReturnType().isArray()) {
                if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != String.class) throw new JaplScriptException("Unknown method signature. " + method);
                String plural = method.getReturnType().getComponentType().getAnnotation(Plural.class).value();
                String applescript = args[0] != null && !((String)args[0]).trim().isEmpty() ? "return " + plural + this.getOfClause() + " where " + args[0] : "return " + plural + this.getOfClause();
                returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                return returnValue;
            } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Integer.TYPE) {
                String plural = method.getReturnType().getAnnotation(Plural.class).value();
                int index = (Integer)args[0] + 1;
                String objectreference = "item " + index + " of " + plural + this.getOfClause();
                if (this.reduceScriptExecutions) {
                    if (index < 1) {
                        throw new ArrayIndexOutOfBoundsException("Index has to be greater than 0");
                    }
                    returnValue = JaplScript.cast(returnType, new ReferenceImpl(objectreference, this.reference.getApplicationReference()));
                    return returnValue;
                } else {
                    String applescript = "return " + objectreference;
                    returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                }
                return returnValue;
            } else {
                if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Id.class) throw new JaplScriptException("Unknown method signature. " + method);
                Id id = (Id)args[0];
                String objectreference = type.value() + " " + id + this.getOfClause();
                if (this.reduceScriptExecutions) {
                    returnValue = JaplScript.cast(returnType, new ReferenceImpl(objectreference, this.reference.getApplicationReference()));
                    return returnValue;
                } else {
                    String applescript = "return " + objectreference;
                    returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                }
            }
            return returnValue;
        } else if (method.getName().startsWith("set")) {
            if (method.getParameterTypes().length != 2 || method.getParameterTypes()[0] != Integer.TYPE) throw new JaplScriptException("Unknown method signature. " + method);
            String plural = method.getReturnType().getAnnotation(Plural.class).value();
            int index = (Integer)args[0] + 1;
            Reference ref = (Reference)args[1];
            String applescript = "set item " + index + " of " + plural + this.getOfClause() + " to (" + ref.getObjectReference() + ")";
            this.executeAppleScript(this.reference, applescript, returnType);
            return returnValue;
        } else {
            if (!method.getName().startsWith("count")) return returnValue;
            Method getMethod = method.getDeclaringClass().getMethod("get" + method.getName().substring("count".length()), new Class[0]);
            if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != String.class) throw new JaplScriptException("Unknown method signature. " + method);
            String plural = getMethod.getReturnType().getComponentType().getAnnotation(Plural.class).value();
            String applescript = args[0] != null && !((String)args[0]).trim().isEmpty() ? "count " + plural + this.getOfClause() + " where " + args[0] : "count " + plural + this.getOfClause();
            returnValue = this.executeAppleScript(this.reference, applescript, returnType);
        }
        return returnValue;
    }

    private <T> T invokeProperty(Method method, Class<T> returnType, Object[] args) throws IOException {
        T returnValue = null;
        Name name = method.getAnnotation(Name.class);
        if (method.getName().startsWith("get")) {
            String applescript = "return " + name.value() + this.getOfClause();
            returnValue = this.executeAppleScript(this.reference, applescript, returnType);
        } else if (method.getName().startsWith("set")) {
            String applescript = "set " + name.value() + this.getOfClause() + " to " + this.encode(args[0]);
            returnValue = this.executeAppleScript(this.reference, applescript, returnType);
        }
        return returnValue;
    }

    private String getOfClause() {
        if (this.reference.getObjectReference() == null) {
            return "";
        }
        return " of " + this.reference.getObjectReference();
    }

    private String encode(Object arg) {
        if (arg instanceof Object[]) {
            return this.encode((Object[])arg);
        }
        if (arg instanceof List) {
            return this.encode((List)arg);
        }
        if (arg instanceof Map) {
            return this.encode((Map)arg);
        }
        for (JaplType<?> type : JaplScript.getTypes()) {
            if (!type._getInterfaceType().isAssignableFrom(arg.getClass())) continue;
            return type._encode(arg);
        }
        if (JaplEnum.class.isAssignableFrom(arg.getClass())) {
            return EncoderEnum.DUMMY._encode(arg);
        }
        return arg.toString();
    }

    private String encode(Object[] array) {
        return Arrays.stream(array).map(this::encode).collect(Collectors.joining(", ", "{", "}"));
    }

    private String encode(List<?> list) {
        return list.stream().map(this::encode).collect(Collectors.joining(", ", "{", "}"));
    }

    private String encode(Map<String, ?> map) {
        return map.entrySet().stream().map(e -> (String)e.getKey() + ": " + this.encode(e.getValue())).collect(Collectors.joining(", ", "{", "}"));
    }

    public <T> T executeAppleScript(Reference reference, String appleScript, Class<T> returnType) throws IOException {
        return this.executeAppleScript(reference.getApplicationReference(), appleScript, returnType);
    }

    private <T> T executeAppleScript(String application, String appleScript, Class<T> returnType) throws IOException {
        return this.executeAppleScript(this.tell(application, appleScript), returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeAppleScript(CharSequence appleScript, Class<T> returnType) throws IOException {
        Session session = Session.getSession();
        if (session == null) {
            ScriptExecutor scriptExecutor = ScriptExecutor.newInstance();
            scriptExecutor.setScript(appleScript);
            String returnValue = scriptExecutor.execute();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(appleScript + " == > " + returnValue);
            }
            if (!returnType.equals(Void.TYPE)) {
                return JaplScript.cast(returnType, new ReferenceImpl(returnValue, this.reference.getApplicationReference()));
            }
            return null;
        }
        if (!returnType.equals(Void.TYPE) && !session.isIgnoreReturnValues()) {
            try {
                session.add(appleScript);
                ScriptExecutor scriptExecutor = ScriptExecutor.newInstance();
                scriptExecutor.setScript(session.getScript());
                String returnValue = scriptExecutor.execute();
                T t = JaplScript.cast(returnType, new ReferenceImpl(returnValue, this.reference.getApplicationReference()));
                return t;
            }
            finally {
                session.reset();
            }
        }
        session.add(appleScript);
        return null;
    }

    private CharSequence tell(String application, String appleScript) {
        StringBuilder sb = new StringBuilder();
        List<Aspect> globalAspects = JaplScript.getGlobalAspects();
        for (Aspect aspect : globalAspects) {
            String before = aspect.before(application, appleScript);
            if (before == null) continue;
            sb.append(before).append("\r\n");
        }
        Session session = Session.getSession();
        if (session != null) {
            List<Aspect> aspects = session.getAspects();
            for (Aspect aspect : aspects) {
                String before = aspect.before(application, appleScript);
                if (before == null) continue;
                sb.append("  ").append(before).append("\r\n");
            }
            sb.append("  ").append(appleScript).append("\r\n");
            Collections.reverse(aspects);
            for (Aspect aspect : aspects) {
                String after = aspect.after(application, appleScript);
                if (after == null) continue;
                sb.append("  ").append(after).append("\r\n");
            }
        } else {
            sb.append(appleScript).append("\r\n");
        }
        Collections.reverse(globalAspects);
        for (Aspect aspect : globalAspects) {
            String after = aspect.after(application, appleScript);
            if (after == null) continue;
            sb.append(after).append("\r\n");
        }
        return sb.toString();
    }

    static {
        try {
            TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            OBJECT_REFERENCE_METHOD = Reference.class.getMethod("getObjectReference", new Class[0]);
            APPLICATION_REFERENCE_METHOD = Reference.class.getMethod("getApplicationReference", new Class[0]);
            CAST_METHOD = Reference.class.getMethod("cast", Class.class);
            IS_INSTANCE_OF_METHOD = Reference.class.getMethod("isInstanceOf", TypeClass.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static enum EncoderEnum implements JaplEnum,
    JaplType<EncoderEnum>
    {
        DUMMY;


        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getCode() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public EncoderEnum _parse(String objectReference, String applicationReference) {
            return null;
        }

        @Override
        public String _encode(Object japlEnum) {
            return ((JaplEnum)japlEnum).getName();
        }

        @Override
        public Class<? extends EncoderEnum> _getInterfaceType() {
            return EncoderEnum.class;
        }
    }
}

