/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Code;
import com.tagtraum.japlscript.Kind;
import com.tagtraum.japlscript.Name;
import com.tagtraum.japlscript.Type;
import com.tagtraum.japlscript.types.TypeClass;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Property {
    private final String code;
    private final String name;
    private final String javaName;
    private final Class<?> javaClass;
    private final TypeClass typeClass;

    public Property(String code, String name, String javaName, Class<?> javaClass, TypeClass typeClass) {
        Objects.requireNonNull(code);
        Objects.requireNonNull(name);
        Objects.requireNonNull(javaName);
        Objects.requireNonNull(javaClass);
        Objects.requireNonNull(typeClass);
        this.code = code;
        this.name = name;
        this.javaName = javaName;
        this.javaClass = javaClass;
        this.typeClass = typeClass;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    public Property(Method method) {
        this(method.getAnnotation(Code.class).value(), method.getAnnotation(Name.class).value(), method.getName().substring(3, 4).toLowerCase(Locale.ROOT) + method.getName().substring(4), method.getReturnType(), TypeClass.getInstance(method.getAnnotation(Type.class).value(), null, null, null));
    }

    public static Set<Property> fromAnnotations(Class<?> klass) {
        return Arrays.stream(klass.getMethods()).filter(m -> !m.getReturnType().equals(Void.TYPE)).filter(m -> m.getAnnotation(Kind.class) != null && m.getAnnotation(Kind.class).value().equals("property")).map(Property::new).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (!this.code.equals(property.code)) {
            return false;
        }
        if (!this.name.equals(property.name)) {
            return false;
        }
        if (!this.javaName.equals(property.javaName)) {
            return false;
        }
        if (!this.javaClass.equals(property.javaClass)) {
            return false;
        }
        return this.typeClass.equals(property.typeClass);
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.javaName.hashCode();
        result = 31 * result + this.javaClass.hashCode();
        result = 31 * result + this.typeClass.hashCode();
        return result;
    }

    public String toString() {
        return "\u00abproperty " + this.code + "\u00bb[name=" + this.name + ",javaName=" + this.javaName + ",javaClass=" + this.javaClass.getName() + ",typeClass=" + this.typeClass + "]";
    }
}

