/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.LocationReference;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.types.Alias;
import com.tagtraum.japlscript.types.JaplScriptFile;
import com.tagtraum.japlscript.types.Picture;
import com.tagtraum.japlscript.types.RGBColor;
import com.tagtraum.japlscript.types.Tdta;
import com.tagtraum.japlscript.types.TypeClass;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Types {
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("_", "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "non-sealed", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private static final Map<String, Class<?>> APPLESCRIPT_TO_JAVA = new HashMap();

    private Types() {
    }

    public static String getStandardJavaType(String applescriptType) {
        if (applescriptType.equalsIgnoreCase("record")) {
            return Map.class.getName() + "<" + String.class.getName() + ", " + Reference.class.getName() + ">";
        }
        String lowercaseApplescriptType = applescriptType.toLowerCase();
        Class<?> javaType = APPLESCRIPT_TO_JAVA.get(lowercaseApplescriptType);
        if (javaType != null) {
            return javaType.getName();
        }
        return null;
    }

    public static String toJavaConstant(String name) {
        return Types.toJavaIdentifier(name.toUpperCase());
    }

    public static String toCamelCaseClassName(String name) {
        return Types.toJavaIdentifier(Types.toCamelCase(name, true));
    }

    public static String toCamelCaseMethodName(String name) {
        return Types.toJavaIdentifier(Types.toCamelCase(name, false));
    }

    public static String toCamelCase(String identifier, boolean uppercaseFirstLetter) {
        StringBuilder sb = new StringBuilder();
        boolean upperCase = uppercaseFirstLetter;
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
            } else if (sb.length() == 0) {
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
            upperCase = false;
        }
        return sb.toString();
    }

    public static String toJavaIdentifier(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        String s = sb.toString();
        if (JAVA_KEYWORDS.contains(s)) {
            return s + "_";
        }
        return s;
    }

    static {
        APPLESCRIPT_TO_JAVA.put("boolean", Boolean.TYPE);
        APPLESCRIPT_TO_JAVA.put("date", Date.class);
        APPLESCRIPT_TO_JAVA.put("integer", Integer.TYPE);
        APPLESCRIPT_TO_JAVA.put("small integer", Short.TYPE);
        APPLESCRIPT_TO_JAVA.put("double integer", Long.TYPE);
        APPLESCRIPT_TO_JAVA.put("unsigned integer", Integer.TYPE);
        APPLESCRIPT_TO_JAVA.put("integer or string", String.class);
        APPLESCRIPT_TO_JAVA.put("international text", String.class);
        APPLESCRIPT_TO_JAVA.put("number", Double.TYPE);
        APPLESCRIPT_TO_JAVA.put("small real", Float.TYPE);
        APPLESCRIPT_TO_JAVA.put("real", Double.TYPE);
        APPLESCRIPT_TO_JAVA.put("string", String.class);
        APPLESCRIPT_TO_JAVA.put("text", String.class);
        APPLESCRIPT_TO_JAVA.put("styled text", String.class);
        APPLESCRIPT_TO_JAVA.put("unicode text", String.class);
        APPLESCRIPT_TO_JAVA.put("file specification", File.class);
        APPLESCRIPT_TO_JAVA.put("list", List.class);
        APPLESCRIPT_TO_JAVA.put("version", String.class);
        APPLESCRIPT_TO_JAVA.put("point", Point.class);
        APPLESCRIPT_TO_JAVA.put("bounding rectangle", Rectangle.class);
        APPLESCRIPT_TO_JAVA.put("rectangle", Rectangle.class);
        APPLESCRIPT_TO_JAVA.put("type class", TypeClass.class);
        APPLESCRIPT_TO_JAVA.put("type", TypeClass.class);
        APPLESCRIPT_TO_JAVA.put("picture", Picture.class);
        APPLESCRIPT_TO_JAVA.put("rgb color", RGBColor.class);
        APPLESCRIPT_TO_JAVA.put("reference", Reference.class);
        APPLESCRIPT_TO_JAVA.put("specifier", Reference.class);
        APPLESCRIPT_TO_JAVA.put("anything", Reference.class);
        APPLESCRIPT_TO_JAVA.put("location reference", LocationReference.class);
        APPLESCRIPT_TO_JAVA.put("alias", Alias.class);
        APPLESCRIPT_TO_JAVA.put("file", JaplScriptFile.class);
        APPLESCRIPT_TO_JAVA.put("tdta", Tdta.class);
        APPLESCRIPT_TO_JAVA.put("raw data", Tdta.class);
    }
}

