/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.execution.ReaderPump;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompiledScript {
    private static final Logger LOG = Logger.getLogger(CompiledScript.class.getName());
    private final CharSequence script;
    private final String scriptFile;

    public CompiledScript(CharSequence script, String scriptFile) {
        this.script = script;
        this.scriptFile = scriptFile;
    }

    public CharSequence getScript() {
        return this.script;
    }

    public String execute() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"osascript", this.scriptFile});
        ReaderPump stderr = new ReaderPump(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        ReaderPump stdout = new ReaderPump(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Thread errThread = new Thread(stderr);
        Thread outThread = new Thread(stdout);
        errThread.start();
        outThread.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        try {
            errThread.join();
            outThread.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString(), e);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Exit value  : " + process.exitValue());
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Return value: " + stdout.getValue());
        }
        if (stderr.getIOException() != null) {
            throw stderr.getIOException();
        }
        if (stdout.getIOException() != null) {
            throw stdout.getIOException();
        }
        if (stderr.getValue().length() > 0) {
            throw new JaplScriptException(stderr.getValue(), this.script.toString());
        }
        return stdout.getValue();
    }
}

