/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.execution.CompiledScript;
import com.tagtraum.japlscript.execution.ReaderPump;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Osacompile {
    private static final Logger LOG = Logger.getLogger(Osacompile.class.getName());
    private static final Path JAPLSCRIPT_CACHE_DIRECTORY = new File(System.getProperty("user.home") + "/Library/Caches/JaplScript/").toPath();
    private final Map<CharSequence, CompiledScript> COMPILED_SCRIPTS = new HashMap<CharSequence, CompiledScript>();

    public CompiledScript compile(CharSequence script) throws IOException {
        CompiledScript compiledScript = this.getCachedCompiledScript(script);
        if (compiledScript != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Script is already compiled.");
            }
            return compiledScript;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Script needs to be compiled.");
        }
        Path scriptFile = Files.createTempFile(JAPLSCRIPT_CACHE_DIRECTORY, "japlscript", ".scpt", new FileAttribute[0]);
        scriptFile.toFile().deleteOnExit();
        Process process = Runtime.getRuntime().exec(new String[]{"osacompile", "-o", scriptFile.toString()});
        OutputStreamWriter stdin = new OutputStreamWriter(process.getOutputStream(), "MacRoman");
        stdin.write(script.toString());
        ((Writer)stdin).close();
        ReaderPump stderr = new ReaderPump(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        ReaderPump stdout = new ReaderPump(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Thread errThread = new Thread(stderr);
        Thread outThread = new Thread(stdout);
        errThread.start();
        outThread.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        try {
            errThread.join();
            outThread.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString(), e);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Exit value  : " + process.exitValue());
        }
        if (stderr.getIOException() != null) {
            throw stderr.getIOException();
        }
        if (stdout.getIOException() != null) {
            throw stdout.getIOException();
        }
        if (stderr.getValue().length() > 0) {
            throw new JaplScriptException(stderr.getValue(), script.toString());
        }
        compiledScript = new CompiledScript(script, scriptFile.toString());
        this.cacheCompiledScript(compiledScript);
        return compiledScript;
    }

    private synchronized CompiledScript getCachedCompiledScript(CharSequence script) {
        return this.COMPILED_SCRIPTS.get(script);
    }

    private synchronized CompiledScript cacheCompiledScript(CompiledScript compiledScript) {
        return this.COMPILED_SCRIPTS.put(compiledScript.getScript(), compiledScript);
    }

    static {
        try {
            Files.createDirectories(JAPLSCRIPT_CACHE_DIRECTORY, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.toString(), e);
        }
    }
}

