/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.ScriptExecutor;
import com.tagtraum.japlscript.Session;
import com.tagtraum.japlscript.execution.BadScriptingAdditionException;
import com.tagtraum.japlscript.execution.CompiledScript;
import com.tagtraum.japlscript.execution.Osacompile;
import com.tagtraum.japlscript.execution.ReaderPump;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Osascript
extends ScriptExecutor {
    private static final Logger LOG = Logger.getLogger(Osascript.class.getName());
    private static final Osacompile osacompile = new Osacompile();
    private static final int NO_ERRORS = 0;
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    @Override
    public String executeImpl() throws IOException {
        int exit;
        Session session = Session.getSession();
        if (session != null && session.isCompile()) {
            CompiledScript compiledScript;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Using compiled script.");
            }
            if ((compiledScript = osacompile.compile(this.getScript())) != null) {
                return compiledScript.execute();
            }
        }
        String[] cmdarray = new String[]{"osascript", "-s", "s", "-"};
        Process process = Runtime.getRuntime().exec(cmdarray);
        OutputStreamWriter stdin = new OutputStreamWriter(process.getOutputStream(), "MacRoman");
        stdin.write(this.getScript().toString());
        ((Writer)stdin).close();
        ReaderPump stderr = new ReaderPump(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        ReaderPump stdout = new ReaderPump(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        Future<?> outFuture = THREAD_POOL.submit(stdout);
        Future<?> errFuture = THREAD_POOL.submit(stderr);
        try {
            exit = process.waitFor();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Exit value: " + exit);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        try {
            errFuture.get();
            outFuture.get();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString(), e);
        }
        catch (ExecutionException e) {
            LOG.log(Level.SEVERE, e.toString(), e);
            throw new IOException(e.toString(), e.getCause());
        }
        if (LOG.isLoggable(Level.FINE) && stdout.getValue() != null && stdout.getValue().length() > 0) {
            String returnValue = stdout.getValue();
            LOG.fine("Return value: " + returnValue.substring(0, Math.min(1024, returnValue.length())));
        }
        if (stderr.getIOException() != null) {
            throw stderr.getIOException();
        }
        if (stdout.getIOException() != null) {
            throw stdout.getIOException();
        }
        if (exit != 0) {
            String stderrValue = stderr.getValue();
            if (stderrValue.length() > 0) {
                if (BadScriptingAdditionException.isBadScriptingAdditionMessage(stderrValue)) {
                    throw new BadScriptingAdditionException(stderrValue);
                }
                throw new JaplScriptException(stderrValue, this.getScript().toString());
            }
            throw new JaplScriptException("Unknown Error", this.getScript().toString());
        }
        return stdout.getValue();
    }
}

