/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScriptingAddition {
    private static final Logger LOG = Logger.getLogger(ScriptingAddition.class.getName());
    private final File executable;
    private final File folder;
    private final Architecture architecture;

    public ScriptingAddition(File file) {
        if (ScriptingAddition.isScriptingAdditionFolder(file)) {
            this.folder = file;
            this.architecture = Architecture.UNKNOWN;
            this.executable = null;
        } else {
            File f;
            this.executable = file;
            for (f = file; f != null && !ScriptingAddition.isScriptingAdditionFolder(f); f = f.getParentFile()) {
            }
            this.folder = f;
            this.architecture = this.determineArchitecture();
        }
    }

    public File getExecutable() {
        return this.executable;
    }

    public File getFolder() {
        return this.folder;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public boolean isLocalArchitecture() {
        return this.architecture == Architecture.UNIVERSAL || System.getProperty("os.arch").equalsIgnoreCase(this.architecture.toString());
    }

    private Architecture determineArchitecture() {
        if (this.executable != null) {
            ProcessBuilder processBuilder = new ProcessBuilder("file", "-b", this.executable.toString());
            StringBuilder sb = new StringBuilder();
            processBuilder.redirectErrorStream(true);
            try {
                Process process = processBuilder.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = in.readLine();
                while (line != null) {
                    sb.append(line);
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.toString(), e);
            }
            String s = sb.toString();
            if (s.contains("i386") && s.contains("ppc")) {
                return Architecture.UNIVERSAL;
            }
            if (s.contains("i386")) {
                return Architecture.I368;
            }
            if (s.contains("ppc")) {
                return Architecture.PPC;
            }
            if (s.contains("x86_64")) {
                return Architecture.X86_64;
            }
            if (s.contains("arm64") || s.contains("aarch64")) {
                return Architecture.AARCH64;
            }
        }
        return Architecture.UNKNOWN;
    }

    private static boolean isScriptingAdditionFolder(File file) {
        return file.isDirectory() && file.getName().endsWith(".osax");
    }

    public String toString() {
        if (this.folder != null) {
            return "[" + this.architecture + " binary]: " + this.folder;
        }
        return "[" + this.architecture + " binary]: " + this.executable;
    }

    public static enum Architecture {
        I368,
        PPC,
        X86_64,
        AARCH64,
        UNIVERSAL,
        UNKNOWN;

    }
}

