/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.generation;

import java.util.Arrays;
import java.util.Objects;

public class AnnotationSignature {
    private final Class<?> type;
    private final String[] arguments;

    public AnnotationSignature(Class<?> type, String ... arguments) {
        Objects.requireNonNull(type, "type is mandatory");
        this.type = type;
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationSignature that = (AnnotationSignature)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return Arrays.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        if (this.arguments == null || this.arguments.length == 0) {
            return "@" + this.type.getName();
        }
        return "@" + this.type.getName() + "(" + String.join((CharSequence)", ", this.arguments) + ")";
    }
}

