/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.generation;

import com.tagtraum.japlscript.generation.AnnotationSignature;
import com.tagtraum.japlscript.generation.EnumSignature;
import com.tagtraum.japlscript.generation.FieldSignature;
import com.tagtraum.japlscript.generation.MethodSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ClassSignature {
    private final String packageName;
    private final String description;
    private final String name;
    private final String type;
    private final List<String> extendedClasses = new ArrayList<String>();
    private final List<String> implementedClasses = new ArrayList<String>();
    private final List<AnnotationSignature> annotationSignatures = new ArrayList<AnnotationSignature>();
    private final List<MethodSignature> methodSignatures = new ArrayList<MethodSignature>();
    private final List<FieldSignature> fieldSignatures = new ArrayList<FieldSignature>();
    private final List<EnumSignature> enumSignatures = new ArrayList<EnumSignature>();

    public ClassSignature(String type, String name, String packageName, String description) {
        this.packageName = packageName;
        this.description = description;
        this.name = name;
        this.type = type;
    }

    public boolean isApplicationClass() {
        return "application".equalsIgnoreCase(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public List<MethodSignature> getMethodSignatures() {
        return this.methodSignatures;
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.name;
    }

    public void add(AnnotationSignature annotationSignature) {
        this.annotationSignatures.add(annotationSignature);
    }

    public void add(EnumSignature enumSignature) {
        this.enumSignatures.add(enumSignature);
    }

    public void add(FieldSignature fieldSignature) {
        this.fieldSignatures.add(fieldSignature);
    }

    public void add(MethodSignature methodSignature) {
        this.methodSignatures.add(methodSignature);
    }

    public boolean contains(MethodSignature methodSignature) {
        return this.methodSignatures.contains(methodSignature);
    }

    public void addExtends(String extendsClass) {
        this.extendedClasses.add(extendsClass);
    }

    public void addImplements(String implementsClass) {
        this.implementedClasses.add(implementsClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(this.packageName).append(";\n\n");
        if (this.description != null) {
            sb.append("/**\n * ").append(this.description).append("\n */\n");
        }
        for (AnnotationSignature annotationSignature : this.annotationSignatures) {
            sb.append(annotationSignature.toString()).append('\n');
        }
        sb.append("public ").append(this.type).append(" ").append(this.name);
        if (!this.extendedClasses.isEmpty()) {
            sb.append(" extends ");
            sb.append(String.join((CharSequence)", ", this.extendedClasses));
        }
        if (!this.implementedClasses.isEmpty()) {
            sb.append(" implements ");
            sb.append(String.join((CharSequence)", ", this.implementedClasses));
        }
        sb.append(" {\n");
        if (!this.enumSignatures.isEmpty()) {
            sb.append(this.enumSignatures.stream().map(EnumSignature::toString).collect(Collectors.joining(",\n    ", "\n    ", ";\n")));
        }
        for (FieldSignature fieldSignature : this.fieldSignatures) {
            sb.append('\n');
            if (fieldSignature.toJavadoc() != null) {
                sb.append(fieldSignature.toJavadoc()).append('\n');
            }
            sb.append(fieldSignature).append('\n');
        }
        for (MethodSignature methodSignature : this.methodSignatures) {
            sb.append('\n');
            if (methodSignature.toJavadoc() != null) {
                sb.append(methodSignature.toJavadoc()).append('\n');
            }
            sb.append(methodSignature).append('\n');
        }
        sb.append("\n}");
        return sb.toString();
    }
}

