/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.generation;

import java.util.Arrays;
import java.util.Objects;

public class EnumSignature {
    private final String name;
    private final String[] arguments;

    public EnumSignature(String name, String ... arguments) {
        Objects.requireNonNull(name, "name is mandatory");
        this.name = name;
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumSignature that = (EnumSignature)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Arrays.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        if (this.arguments == null || this.arguments.length == 0) {
            return this.name;
        }
        return this.name + "(" + String.join((CharSequence)", ", this.arguments) + ")";
    }
}

