/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.generation;

import com.tagtraum.japlscript.generation.AnnotationSignature;
import com.tagtraum.japlscript.generation.ParameterSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MethodSignature {
    private final String name;
    private final List<ParameterSignature> parameterSignatures = new ArrayList<ParameterSignature>();
    private final List<AnnotationSignature> annotationSignatures = new ArrayList<AnnotationSignature>();
    private String returnType;
    private String returnTypeDescription;
    private String body;
    private boolean defaultMethod;
    private String description;
    private String visibility;

    public MethodSignature(String name) {
        Objects.requireNonNull(name, "name is mandatory");
        this.name = name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getReturnTypeDescription() {
        return this.returnTypeDescription;
    }

    public void setReturnTypeDescription(String returnTypeDescription) {
        this.returnTypeDescription = returnTypeDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public void setDefaultMethod(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    public void add(AnnotationSignature annotationSignature) {
        this.annotationSignatures.add(annotationSignature);
    }

    public String getName() {
        return this.name;
    }

    public void add(ParameterSignature type) {
        this.parameterSignatures.add(type);
    }

    public List<ParameterSignature> getParameterSignatures() {
        return this.parameterSignatures;
    }

    public List<AnnotationSignature> getAnnotationSignatures() {
        return this.annotationSignatures;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature that = (MethodSignature)obj;
        return this.name.equals(that.name) && this.returnType.equals(that.returnType) && this.parameterSignatures.equals(that.parameterSignatures);
    }

    public String toJavadoc() {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        if (this.description != null) {
            sb.append(" * ").append(this.description).append('\n');
        }
        sb.append(" *\n");
        for (ParameterSignature parameterSignature : this.parameterSignatures) {
            sb.append(parameterSignature.toJavadoc()).append('\n');
        }
        if (this.returnTypeDescription != null) {
            sb.append(" * @return ").append(this.returnTypeDescription).append('\n');
        }
        sb.append(" */");
        return sb.toString();
    }

    public String toString() {
        List annotations = this.annotationSignatures.stream().map(AnnotationSignature::toString).sorted().collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (String annotationSignature : annotations) {
            sb.append(annotationSignature).append('\n');
        }
        if (this.visibility != null) {
            sb.append(this.visibility).append(' ');
        }
        if (this.defaultMethod) {
            sb.append("default ");
        }
        if (this.returnType != null) {
            sb.append(this.returnType).append(' ');
        }
        sb.append(this.name).append('(');
        sb.append(this.parameterSignatures.stream().map(ParameterSignature::toString).collect(Collectors.joining(", ")));
        sb.append(')');
        if (this.body != null) {
            sb.append(" {\n");
            sb.append("    ").append(this.body);
            sb.append("\n}");
        } else {
            sb.append(';');
        }
        return sb.toString();
    }
}

