/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.generation;

import com.tagtraum.japlscript.generation.AnnotationSignature;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public class ParameterSignature {
    private final AnnotationSignature[] annotations;
    private final String name;
    private final String type;
    private final String description;

    public ParameterSignature(String name, String description, String type, AnnotationSignature ... annotations) {
        Objects.requireNonNull(name, "name is mandatory");
        Objects.requireNonNull(type, "type is mandatory");
        this.annotations = annotations;
        if (this.annotations != null) {
            Arrays.sort(this.annotations, Comparator.comparing(AnnotationSignature::toString));
        }
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public String toJavadoc() {
        if (this.description == null) {
            return " * @param " + this.name;
        }
        return " * @param " + this.name + " " + this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterSignature that = (ParameterSignature)o;
        if (!Arrays.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.annotations);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.annotations != null) {
            for (AnnotationSignature annotationSignature : this.annotations) {
                sb.append(annotationSignature).append(' ');
            }
        }
        sb.append(this.type).append(' ').append(this.name);
        return sb.toString();
    }
}

