/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.types.JaplScriptFile;
import com.tagtraum.japlscript.types.ReferenceImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Alias
extends ReferenceImpl {
    private static final Logger LOG = Logger.getLogger(Alias.class.getName());
    private final Path file;
    private String alias;
    private static final Alias instance = new Alias();

    private Alias() {
        super(null, null);
        this.file = null;
    }

    public Alias(String objectReference, String applicationReference) {
        super(Alias.toObjectReference(objectReference), applicationReference);
        int startQuote = objectReference.indexOf(34);
        if (startQuote != -1) {
            int endQuote = objectReference.lastIndexOf(34);
            this.alias = objectReference.substring(startQuote + 1, endQuote);
            this.file = Paths.get("/Volumes/" + this.alias.replace(':', '/'), new String[0]);
        } else {
            this.alias = objectReference;
            this.file = Paths.get(objectReference, new String[0]);
        }
    }

    public static Alias getInstance() {
        return instance;
    }

    public Alias(Path file) throws IOException {
        super(JaplScriptFile.toApplescriptFile(file), null);
        this.file = file;
    }

    public Alias(File file) throws IOException {
        this(file.toPath());
    }

    private static String toObjectReference(String objectReference) {
        if (objectReference.startsWith("/")) {
            try {
                return JaplScriptFile.toApplescriptFile(new File(objectReference));
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.toString(), e);
                return objectReference;
            }
        }
        return objectReference;
    }

    public File getFile() {
        return this.file.toFile();
    }

    public Path getPath() {
        return this.file;
    }

    public URL getURL() throws MalformedURLException {
        if (this.file.toString().startsWith("/")) {
            return new URL("file://localhost" + this.file);
        }
        return new URL("file://localhost/" + this.file);
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public String toString() {
        return this.getObjectReference();
    }
}

