/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.DateParser;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.JaplType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements JaplType<java.util.Date> {
    private static final Date instance = new Date();

    private Date() {
    }

    public static Date getInstance() {
        return instance;
    }

    @Override
    public String _encode(Object date) {
        if (date == null) {
            return "null";
        }
        SimpleDateFormat dateHelperFormat = new SimpleDateFormat("'my createDate('yyyy, M, d, H, m, s')'");
        return dateHelperFormat.format(date);
    }

    @Override
    public java.util.Date _parse(String objectReference, String applicationReference) {
        if (objectReference == null) {
            return null;
        }
        return Date.parseDate(objectReference);
    }

    private static java.util.Date parseDate(String objectReference) {
        SimpleDateFormat rfc3339Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        rfc3339Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return rfc3339Format.parse(objectReference);
        }
        catch (ParseException parseException) {
            int firstQuote = objectReference.indexOf(34);
            int lastQuote = objectReference.lastIndexOf(34);
            if (firstQuote < 0 || lastQuote < 0) {
                throw new JaplScriptException("Failed to parse date: " + objectReference);
            }
            String d = objectReference.substring(firstQuote + 1, lastQuote);
            try {
                return new DateParser(Locale.getDefault()).parse(d);
            }
            catch (ParseException parseException2) {
                try {
                    return new DateParser(Locale.US).parse(d);
                }
                catch (ParseException parseException3) {
                    int format;
                    for (format = 0; format <= 3; ++format) {
                        try {
                            return DateFormat.getDateTimeInstance(format, format, Locale.US).parse(d);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    for (format = 0; format <= 3; ++format) {
                        try {
                            return DateFormat.getDateTimeInstance(format, format, Locale.getDefault()).parse(d);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    throw new JaplScriptException("Failed to parse date: " + objectReference);
                }
            }
        }
    }

    @Override
    public Class<java.util.Date> _getInterfaceType() {
        return java.util.Date.class;
    }
}

