/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.JaplScript;
import com.tagtraum.japlscript.types.ReferenceImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JaplScriptFile
extends ReferenceImpl {
    private static final JaplScriptFile instance = new JaplScriptFile();
    private final Path file;

    private JaplScriptFile() {
        super(null, null);
        this.file = null;
    }

    public JaplScriptFile(String objectReference, String applicationReference) {
        super(objectReference, applicationReference);
        int startQuote = objectReference.indexOf(34);
        int endQuote = objectReference.lastIndexOf(34);
        if (startQuote != -1 && endQuote != -1 && startQuote < endQuote && objectReference.contains(":")) {
            String alias = objectReference.substring(startQuote + 1, endQuote);
            this.file = Paths.get("/Volumes/" + alias.replace(':', '/'), new String[0]);
        } else {
            this.file = startQuote != -1 && endQuote != -1 && startQuote < endQuote && objectReference.contains("(POSIX file \"") ? Paths.get(objectReference.substring(startQuote + 1, endQuote), new String[0]) : Paths.get(objectReference, new String[0]);
        }
    }

    public JaplScriptFile(File file) throws IOException {
        this(file.toPath());
    }

    public JaplScriptFile(Path file) throws IOException {
        super(JaplScriptFile.toApplescriptFile(file), null);
        this.file = file;
    }

    public static JaplScriptFile getInstance() {
        return instance;
    }

    public static String toApplescriptFile(File javaFile) throws IOException {
        return "(POSIX file " + JaplScript.quote(javaFile.getCanonicalFile().toString()) + ")";
    }

    public static String toApplescriptFile(Path javaPath) throws IOException {
        return JaplScriptFile.toApplescriptFile(javaPath.toFile());
    }

    public File getFile() {
        return this.file.toFile();
    }

    public Path getPath() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.getObjectReference();
    }
}

