/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.JaplType;
import java.awt.Color;

public class RGBColor
implements JaplType<Color> {
    private static final RGBColor instance = new RGBColor();

    private RGBColor() {
    }

    public static RGBColor getInstance() {
        return instance;
    }

    @Override
    public Color _parse(String objectReference, String applicationReference) {
        String t = objectReference.trim();
        if (t.isEmpty()) {
            return null;
        }
        if (t.startsWith("{") && t.endsWith("}")) {
            String sub = t.substring(1, t.length() - 1);
            String[] parts = sub.split(",");
            int r = Integer.parseInt(parts[0].trim());
            int g = Integer.parseInt(parts[1].trim());
            int b = Integer.parseInt(parts[2].trim());
            return new Color((float)r / 65535.0f, (float)g / 65535.0f, (float)b / 65535.0f);
        }
        throw new JaplScriptException("Failed to parse RGBColor: " + objectReference);
    }

    @Override
    public String _encode(Object object) {
        if (object == null) {
            return "null";
        }
        Color color = (Color)object;
        float[] rgbColorComponents = color.getRGBColorComponents(null);
        return "{" + (int)((double)(rgbColorComponents[0] * 65535.0f) - 0.5) + ", " + (int)((double)(rgbColorComponents[1] * 65535.0f) - 0.5) + ", " + (int)((double)(rgbColorComponents[2] * 65535.0f) - 0.5) + "}";
    }

    @Override
    public Class<Color> _getInterfaceType() {
        return Color.class;
    }
}

