/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.JaplScript;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.JaplType;
import com.tagtraum.japlscript.ObjectInvocationHandler;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.types.TypeClass;

public class ReferenceImpl
implements Reference,
JaplType<Reference> {
    private static final ReferenceImpl instance = new ReferenceImpl();
    private final String objectReference;
    private final String applicationReference;
    private TypeClass typeClass;

    private ReferenceImpl() {
        this.objectReference = null;
        this.applicationReference = null;
    }

    public static ReferenceImpl getInstance() {
        return instance;
    }

    public ReferenceImpl(String objectReference, String applicationReference) {
        this.objectReference = objectReference;
        this.applicationReference = applicationReference;
    }

    @Override
    public String getObjectReference() {
        return this.objectReference;
    }

    @Override
    public String getApplicationReference() {
        return this.applicationReference;
    }

    @Override
    public synchronized TypeClass getTypeClass() {
        if (this.typeClass == null) {
            this.typeClass = new ObjectInvocationHandler(this).getTypeClass();
        }
        return this.typeClass;
    }

    @Override
    public boolean isInstanceOf(TypeClass typeClass) {
        return typeClass != null && typeClass.isInstance(this);
    }

    public String toString() {
        return "[" + this.applicationReference + "]: " + this.objectReference;
    }

    public int hashCode() {
        if (this.objectReference == null) {
            return 0;
        }
        return this.objectReference.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceImpl)) {
            return false;
        }
        ReferenceImpl reference = (ReferenceImpl)o;
        if (this.objectReference != null ? !this.objectReference.equals(reference.objectReference) : reference.objectReference != null) {
            return false;
        }
        return this.applicationReference != null ? this.applicationReference.equals(reference.applicationReference) : reference.applicationReference == null;
    }

    @Override
    public <T> T cast(Class<T> klass) {
        return JaplScript.cast(klass, this);
    }

    @Override
    public String _encode(Object reference) {
        return ((Reference)reference).getObjectReference();
    }

    @Override
    public Class<? extends Reference> _getInterfaceType() {
        return this.getClass() == ReferenceImpl.class ? Reference.class : this.getClass();
    }

    @Override
    public ReferenceImpl _parse(String objectReference, String applicationReference) {
        if (objectReference == null || "null".equals(objectReference) || "missing value".equals(objectReference)) {
            return null;
        }
        try {
            return (ReferenceImpl)this.getClass().getConstructor(String.class, String.class).newInstance(objectReference, applicationReference);
        }
        catch (Exception e) {
            throw new JaplScriptException("Failed to create new ReferenceImpl for " + this.getClass(), e);
        }
    }
}

