/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript.types;

import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.types.ReferenceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TypeClass
extends ReferenceImpl {
    private static final Map<String, TypeClass> TYPE_CLASS_MAP = new HashMap<String, TypeClass>();
    private static final TypeClass instance = new TypeClass();
    private String code;
    private TypeClass superClass;

    public TypeClass() {
        super(null, null);
        this.code = null;
        this.superClass = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeClass(String objectReference, String applicationReference) {
        super(TypeClass.lookupRefName(objectReference), applicationReference);
        if (objectReference.startsWith("\u00ab")) {
            this.code = objectReference;
        }
        Class<TypeClass> clazz = TypeClass.class;
        synchronized (TypeClass.class) {
            TypeClass typeClass = TYPE_CLASS_MAP.get(objectReference);
            if (typeClass != null) {
                this.superClass = typeClass.getSuperClass();
                this.code = typeClass.getCode();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static TypeClass getInstance() {
        return instance;
    }

    private static synchronized String lookupRefName(String name) {
        TypeClass typeClass = TYPE_CLASS_MAP.get(name);
        return typeClass != null ? typeClass.getName() : name;
    }

    private TypeClass(String name, String code, String applicationReference, TypeClass superClass) {
        super(name, applicationReference);
        this.code = code;
        this.superClass = superClass;
    }

    public static synchronized TypeClass getInstance(String name, String code, String applicationReference, TypeClass superClass) {
        TypeClass typeClass = TYPE_CLASS_MAP.get(name);
        if (typeClass == null) {
            typeClass = new TypeClass(name, code, applicationReference, superClass);
            if (name != null && code != null && applicationReference == null) {
                TYPE_CLASS_MAP.put(name, typeClass);
                TYPE_CLASS_MAP.put(code, typeClass);
            }
        }
        return typeClass;
    }

    public TypeClass getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.getObjectReference();
    }

    public String getCode() {
        return this.code;
    }

    public boolean isAssignableFrom(TypeClass cls) {
        TypeClass otherClass;
        if (cls == null) {
            return false;
        }
        for (otherClass = cls; otherClass != null && !otherClass.equals(this); otherClass = otherClass.getSuperClass()) {
        }
        return otherClass != null && otherClass.equals(this);
    }

    public boolean isInstance(Object object) {
        TypeClass thisClass;
        if (object == null) {
            return false;
        }
        if (!(object instanceof Reference)) {
            return false;
        }
        Reference reference = (Reference)object;
        for (thisClass = reference.getTypeClass(); thisClass != null && !thisClass.equals(this); thisClass = thisClass.getSuperClass()) {
        }
        return thisClass != null && thisClass.equals(this);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TypeClass)) {
            return false;
        }
        TypeClass that = (TypeClass)obj;
        if (this == that) {
            return true;
        }
        return Objects.equals(this.getObjectReference(), that.getObjectReference()) || Objects.equals(this.getObjectReference(), that.code) || this.code != null && this.code.equals(that.code) || this.code != null && this.code.equals(that.getObjectReference());
    }

    @Override
    public String toString() {
        if (this.getObjectReference().equals(this.code)) {
            return this.getObjectReference();
        }
        return this.getObjectReference() + "/" + this.code;
    }
}

