/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.bk.devops.atom.common.Constants;
import com.tencent.bk.devops.atom.pojo.AtomBaseParam;
import com.tencent.bk.devops.atom.pojo.AtomResult;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomContext<T extends AtomBaseParam> {
    private final String dataDir;
    private final String inputFile;
    private final String outputFile;
    private final T param;
    private final AtomResult result;
    private static final String ATOM_FILE_ENCODING = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(AtomContext.class);

    AtomContext(Class<T> paramClazz) throws IOException {
        String value = System.getenv(Constants.DATA_DIR_ENV);
        if (value == null || value.trim().length() == 0 || !new File(value).isDirectory()) {
            value = System.getProperty("user.dir");
        }
        this.dataDir = value;
        value = System.getenv(Constants.INPUT_FILE_ENV);
        if (value == null || value.trim().length() == 0) {
            value = "input.json";
        }
        this.inputFile = value;
        value = System.getenv(Constants.OUTPUT_FILE_ENV);
        if (value == null || value.trim().length() == 0) {
            value = "output.json";
        }
        this.outputFile = value;
        this.param = this.readParam(paramClazz);
        this.result = new AtomResult();
    }

    public T getParam() {
        return this.param;
    }

    public String getSensitiveConfParam(String filedName) {
        Map<String, String> bkSensitiveConfInfo = ((AtomBaseParam)this.param).getBkSensitiveConfInfo();
        if (null != bkSensitiveConfInfo) {
            return bkSensitiveConfInfo.get(filedName);
        }
        return null;
    }

    public AtomResult getResult() {
        return this.result;
    }

    private T readParam(Class<T> paramClazz) throws IOException {
        String json = FileUtils.readFileToString((File)new File(this.dataDir + "/" + this.inputFile), (String)ATOM_FILE_ENCODING);
        return (T)((AtomBaseParam)JsonUtil.fromJson(json, paramClazz));
    }

    public Map<String, Object> getAllParameters() throws IOException {
        String json = FileUtils.readFileToString((File)new File(this.dataDir + "/" + this.inputFile), (String)ATOM_FILE_ENCODING);
        return JsonUtil.fromJson(json, new TypeReference<Map<String, Object>>(){});
    }

    void persistent() throws IOException {
        String json = JsonUtil.toJson(this.result);
        FileUtils.write((File)new File(this.dataDir + "/" + this.outputFile), (CharSequence)json, (String)ATOM_FILE_ENCODING);
    }
}

