/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.api;

import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.api.Header;
import com.tencent.bk.devops.atom.common.BuildType;
import com.tencent.bk.devops.atom.common.Constants;
import com.tencent.bk.devops.atom.utils.http.SdkUtils;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkEnv {
    private static final Logger logger = LoggerFactory.getLogger(SdkEnv.class);
    private BuildType buildType;
    private String projectId;
    private String agentId;
    private String secretKey;
    private String gateway;
    private String buildId;
    private String vmSeqId;
    private static SdkEnv instance;

    static Map<String, String> getSdkHeader() {
        HashMap map = Maps.newHashMap();
        map.put(Header.AUTH_HEADER_DEVOPS_BUILD_TYPE, SdkEnv.instance.buildType.name());
        map.put(Header.AUTH_HEADER_DEVOPS_PROJECT_ID, SdkEnv.instance.projectId);
        map.put(Header.AUTH_HEADER_DEVOPS_AGENT_SECRET_KEY, SdkEnv.instance.secretKey);
        map.put(Header.AUTH_HEADER_DEVOPS_AGENT_ID, SdkEnv.instance.agentId);
        map.put(Header.AUTH_HEADER_DEVOPS_VM_SEQ_ID, SdkEnv.instance.vmSeqId);
        map.put(Header.AUTH_HEADER_DEVOPS_BUILD_ID, SdkEnv.instance.buildId);
        return map;
    }

    public static String projectId() {
        return SdkEnv.instance.projectId;
    }

    public static String agentId() {
        return SdkEnv.instance.agentId;
    }

    public static String buildId() {
        return SdkEnv.instance.buildId;
    }

    public static String vmSeqId() {
        return SdkEnv.instance.vmSeqId;
    }

    public static String getVmSeqId() {
        return SdkEnv.instance.vmSeqId;
    }

    public static void init() throws IOException {
        String dataDir = System.getenv(Constants.DATA_DIR_ENV);
        if (dataDir == null || dataDir.trim().length() == 0 || !new File(dataDir).isDirectory()) {
            dataDir = System.getProperty("user.dir");
        }
        String sdkFile = ".sdk.json";
        File file = new File(dataDir + "/" + sdkFile);
        String json = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        boolean flag = file.delete();
        logger.info("delete file result is:{}", (Object)flag);
        instance = JsonUtil.fromJson(json, SdkEnv.class);
    }

    public static String genUrl(String path) {
        if (path.startsWith("/")) {
            return SdkEnv.getGatewayHost() + "/" + path.substring(1).trim();
        }
        return SdkEnv.getGatewayHost() + "/" + path.trim();
    }

    public static String getGatewayHost() {
        if (SdkUtils.hasProtocol(SdkEnv.instance.gateway).booleanValue()) {
            return SdkEnv.instance.gateway;
        }
        return "http://" + SdkEnv.instance.gateway;
    }

    public void setBuildType(BuildType buildType) {
        this.buildType = buildType;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public void setVmSeqId(String vmSeqId) {
        this.vmSeqId = vmSeqId;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getBuildId() {
        return this.buildId;
    }
}

