/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.utils.http;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private static final Logger logger = LoggerFactory.getLogger(OkHttpUtils.class);
    private static X509TrustManager[] trustAllCerts = new X509TrustManager[1];

    private static OkHttpClient createClient(long connectTimeout, long writeTimeout, long readTimeout) {
        long finalConnectTimeout = 5L;
        long finalWriteTimeout = 60L;
        long finalReadTimeout = 60L;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (connectTimeout > 0L) {
            finalConnectTimeout = connectTimeout;
        }
        if (writeTimeout > 0L) {
            finalWriteTimeout = writeTimeout;
        }
        if (readTimeout > 0L) {
            finalReadTimeout = readTimeout;
        }
        builder.sslSocketFactory(OkHttpUtils.sslSocketFactory(), trustAllCerts[0]);
        builder.writeTimeout(finalConnectTimeout, TimeUnit.SECONDS);
        builder.writeTimeout(finalWriteTimeout, TimeUnit.SECONDS);
        builder.readTimeout(finalReadTimeout, TimeUnit.SECONDS);
        return builder.build();
    }

    private static SSLSocketFactory sslSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException("fail to create sslSocketFactory");
        }
    }

    private static Request.Builder getBuilder(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (null != headers) {
            builder.headers(Headers.of(headers));
        }
        return builder;
    }

    public static String doGet(String url) {
        return OkHttpUtils.doGet(url, null);
    }

    public static String doGet(String url, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doGet(url, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doGet(String url, Map<String, String> headers) {
        return OkHttpUtils.doGet(url, headers, -1L, -1L, -1L);
    }

    public static String doGet(String url, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        Request request = builder.get().build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPost(String url, String jsonParam) {
        return OkHttpUtils.doPost(url, jsonParam, null);
    }

    public static String doPost(String url, String jsonParam, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doPost(url, jsonParam, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPost(String url, String jsonParam, Map<String, String> headers) {
        return OkHttpUtils.doPost(url, jsonParam, headers, -1L, -1L, -1L);
    }

    public static String doPost(String url, String jsonParam, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_JSON), (String)jsonParam);
        Request request = builder.post(body).build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPut(String url, String jsonParam) {
        return OkHttpUtils.doPut(url, jsonParam, null);
    }

    public static String doPut(String url, String jsonParam, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doPut(url, jsonParam, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPut(String url, String jsonParam, Map<String, String> headers) {
        return OkHttpUtils.doPut(url, jsonParam, headers, -1L, -1L, -1L);
    }

    public static String doPut(String url, String jsonParam, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_JSON), (String)jsonParam);
        Request request = builder.put(body).build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doDelete(String url) {
        return OkHttpUtils.doDelete(url, null);
    }

    public static String doDelete(String url, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doDelete(url, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doDelete(String url, Map<String, String> headers) {
        return OkHttpUtils.doDelete(url, headers, -1L, -1L, -1L);
    }

    public static String doDelete(String url, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        Request request = builder.delete().build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doHttp(Request request, long connectTimeout, long writeTimeout, long readTimeout) {
        OkHttpClient httpClient = OkHttpUtils.createClient(connectTimeout, writeTimeout, readTimeout);
        Response response = null;
        String responseContent = null;
        try {
            response = httpClient.newCall(request).execute();
            assert (response.body() != null);
            responseContent = response.body().string();
        }
        catch (IOException e) {
            logger.error("http send  throw Exception", (Throwable)e);
        }
        finally {
            if (response != null) {
                assert (response.body() != null);
                response.body().close();
            }
        }
        if (response != null && !response.isSuccessful()) {
            logger.error("Fail to request(" + request + ") with code " + response.code() + " , message " + response.message() + " and response" + responseContent);
        }
        return responseContent;
    }

    static {
        OkHttpUtils.trustAllCerts[0] = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

