/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class JsonMapper {
    private ObjectMapper mapper = new ObjectMapper();

    private JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static JsonMapper nonEmptyMapper() {
        return JsonMapper.build(JsonInclude.Include.NON_EMPTY);
    }

    public static JsonMapper allOutPutMapper() {
        return JsonMapper.build(JsonInclude.Include.ALWAYS);
    }

    public static JsonMapper build(JsonInclude.Include include) {
        return new JsonMapper(include);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            return null;
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            return null;
        }
    }

    public <T> T fromJson(String jsonString, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            return null;
        }
    }
}

