/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom;

import com.tencent.bk.devops.atom.AtomContext;
import com.tencent.bk.devops.atom.api.SdkEnv;
import com.tencent.bk.devops.atom.common.Status;
import com.tencent.bk.devops.atom.pojo.AtomBaseParam;
import com.tencent.bk.devops.atom.spi.AtomService;
import com.tencent.bk.devops.atom.spi.ServiceLoader;
import com.tencent.bk.devops.atom.spi.TaskAtom;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomRunner {
    private static final Logger logger = LoggerFactory.getLogger(AtomRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        TaskAtom atom = ServiceLoader.load(TaskAtom.class);
        AtomService annotation = atom.getClass().getAnnotation(AtomService.class);
        Class<? extends AtomBaseParam> tClass = annotation.paramClass();
        SdkEnv.init();
        AtomContext<? extends AtomBaseParam> context = AtomRunner.getContext(tClass);
        try {
            atom.execute(context);
        }
        catch (Throwable e) {
            logger.error("Unknown Error\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            context.getResult().setStatus(Status.error);
            context.getResult().setMessage("Unknown Error\uff1a" + e.getMessage());
        }
        finally {
            context.persistent();
        }
    }

    private static <T extends AtomBaseParam> AtomContext<T> getContext(Class<T> tClass) throws IOException {
        return new AtomContext<T>(tClass);
    }
}

