/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.spi;

import com.tencent.bk.devops.atom.spi.AtomService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceLoader {
    private static final Map<String, Object> CACHE = new ConcurrentHashMap<String, Object>();

    public static void clear() {
        CACHE.clear();
    }

    public static <T> T load(Class<T> clazz) {
        return ServiceLoader.load(clazz, null);
    }

    public static <T> T load(Class<T> clazz, String name) {
        String key = clazz.getName();
        Object o = CACHE.get(key);
        if (o == null) {
            T t = ServiceLoader.load0(clazz, name);
            if (t != null) {
                CACHE.put(key, t);
                return t;
            }
        } else if (clazz.isInstance(o)) {
            return (T)o;
        }
        return ServiceLoader.load0(clazz, name);
    }

    private static <T> T load0(Class<T> clazz, String name) {
        java.util.ServiceLoader<T> factories = java.util.ServiceLoader.load(clazz);
        T t = ServiceLoader.filterByName(factories, name);
        if (t == null) {
            factories = java.util.ServiceLoader.load(clazz, ServiceLoader.class.getClassLoader());
            t = ServiceLoader.filterByName(factories, name);
        }
        if (t != null) {
            return t;
        }
        throw new IllegalStateException("Cannot find META-INF/services/" + clazz.getName() + " on classpath");
    }

    private static <T> T filterByName(java.util.ServiceLoader<T> factories, String name) {
        Iterator<T> it = factories.iterator();
        if (name == null) {
            List<T> list = ServiceLoader.findList(it);
            if (list.size() > 0) {
                return list.get(0);
            }
        } else {
            while (it.hasNext()) {
                T t = it.next();
                if (!name.equals(t.getClass().getName()) && !name.equals(t.getClass().getSimpleName())) continue;
                return t;
            }
        }
        return null;
    }

    private static <T> List<T> findList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>(2);
        while (it.hasNext()) {
            list.add(it.next());
        }
        if (list.size() > 1) {
            list.sort((o1, o2) -> {
                AtomService spi1 = o1.getClass().getAnnotation(AtomService.class);
                AtomService spi2 = o2.getClass().getAnnotation(AtomService.class);
                int order1 = spi1 == null ? 0 : spi1.order();
                int order2 = spi2 == null ? 0 : spi2.order();
                return order1 - order2;
            });
        }
        return list;
    }
}

