/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.utils.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private static final Logger logger = LoggerFactory.getLogger(OkHttpUtils.class);
    private static long finalConnectTimeout = 5L;
    private static long finalWriteTimeout = 60L;
    private static long finalReadTimeout = 60L;
    private static final long finalLongConnectTimeout = 30L;
    private static final long finalLongWriteTimeout = 1800L;
    private static final long finalLongReadTimeout = 1800L;
    private static final X509TrustManager[] trustAllCerts = new X509TrustManager[1];

    private static OkHttpClient createClient(long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.createRetryOptionClient(connectTimeout, writeTimeout, readTimeout, true);
    }

    private static OkHttpClient createLongClient() {
        return OkHttpUtils.createRetryOptionClient(30L, 1800L, 1800L, true);
    }

    private static OkHttpClient createRetryOptionClient(long connectTimeout, long writeTimeout, long readTimeout, boolean isRetry) {
        if (connectTimeout > 0L) {
            finalConnectTimeout = connectTimeout;
        }
        if (writeTimeout > 0L) {
            finalWriteTimeout = writeTimeout;
        }
        if (readTimeout > 0L) {
            finalReadTimeout = readTimeout;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.sslSocketFactory(OkHttpUtils.sslSocketFactory(), trustAllCerts[0]);
        builder.writeTimeout(finalConnectTimeout, TimeUnit.SECONDS);
        builder.writeTimeout(finalWriteTimeout, TimeUnit.SECONDS);
        builder.readTimeout(finalReadTimeout, TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(isRetry);
        return builder.build();
    }

    private static SSLSocketFactory sslSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException("fail to create sslSocketFactory");
        }
    }

    private static Request.Builder getBuilder(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (null != headers) {
            builder.headers(Headers.of(headers));
        }
        return builder;
    }

    public static String doGet(String url) {
        return OkHttpUtils.doGet(url, null);
    }

    public static String doGet(String url, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doGet(url, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doGet(String url, Map<String, String> headers) {
        return OkHttpUtils.doGet(url, headers, -1L, -1L, -1L);
    }

    public static String doGet(String url, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        Request request = builder.get().build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPost(String url, String jsonParam) {
        return OkHttpUtils.doPost(url, jsonParam, null);
    }

    public static String doPost(String url, String jsonParam, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doPost(url, jsonParam, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPost(String url, String jsonParam, Map<String, String> headers) {
        return OkHttpUtils.doPost(url, jsonParam, headers, -1L, -1L, -1L);
    }

    public static String doPost(String url, String jsonParam, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_JSON), (String)jsonParam);
        Request request = builder.post(body).build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPut(String url, String jsonParam) {
        return OkHttpUtils.doPut(url, jsonParam, null);
    }

    public static String doPut(String url, String jsonParam, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doPut(url, jsonParam, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doPut(String url, String jsonParam, Map<String, String> headers) {
        return OkHttpUtils.doPut(url, jsonParam, headers, -1L, -1L, -1L);
    }

    public static String doPut(String url, String jsonParam, Map<String, String> headers, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_JSON), (String)jsonParam);
        Request request = builder.put(body).build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doDelete(String url) {
        return OkHttpUtils.doDelete(url, null, null);
    }

    public static String doDelete(String url, long connectTimeout, long writeTimeout, long readTimeout) {
        return OkHttpUtils.doDelete(url, null, null, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doDelete(String url, Map<String, String> headers) {
        return OkHttpUtils.doDelete(url, headers, null, -1L, -1L, -1L);
    }

    public static String doDelete(String url, String body, Map<String, String> headers) {
        return OkHttpUtils.doDelete(url, headers, body, -1L, -1L, -1L);
    }

    public static String doDelete(String url, Map<String, String> headers, String body, long connectTimeout, long writeTimeout, long readTimeout) {
        Request.Builder builder = OkHttpUtils.getBuilder(url, headers);
        Request request = StringUtils.isBlank((CharSequence)body) ? builder.delete().build() : builder.delete(RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_JSON), (String)body)).build();
        return OkHttpUtils.doHttp(request, connectTimeout, writeTimeout, readTimeout);
    }

    public static String doHttp(Request request) {
        return OkHttpUtils.doHttp(request, finalConnectTimeout, finalWriteTimeout, finalReadTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doHttp(Request request, long connectTimeout, long writeTimeout, long readTimeout) {
        OkHttpClient httpClient = OkHttpUtils.createClient(connectTimeout, writeTimeout, readTimeout);
        Response response = null;
        String responseContent = null;
        try {
            response = httpClient.newCall(request).execute();
            assert (response.body() != null);
            responseContent = response.body().string();
        }
        catch (IOException e) {
            logger.error("http send  throw Exception", e);
        }
        finally {
            if (response != null) {
                assert (response.body() != null);
                response.body().close();
            }
        }
        if (response != null && !response.isSuccessful()) {
            logger.error("Fail to request(" + request + ") with code " + response.code() + " , message " + response.message() + " and response" + responseContent);
        }
        return responseContent;
    }

    public static Response doHttpRaw(Request request) {
        return OkHttpUtils.doHttpRaw(request, finalConnectTimeout, finalWriteTimeout, finalReadTimeout, false);
    }

    public static Response doHttpRaw(Request request, boolean isRetry) {
        return OkHttpUtils.doHttpRaw(request, finalConnectTimeout, finalWriteTimeout, finalReadTimeout, isRetry);
    }

    public static Response doHttpRaw(Request request, long connectTimeout, long writeTimeout, long readTimeout, boolean isRetry) {
        OkHttpClient httpClient = OkHttpUtils.createRetryOptionClient(connectTimeout, writeTimeout, readTimeout, isRetry);
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void downloadFile(String url, File destPath) {
        Request request = new Request.Builder().url(url).get().build();
        OkHttpClient httpClient = OkHttpUtils.createLongClient();
        try (Response response = httpClient.newCall(request).execute();){
            int code = response.code();
            if (code == 404) {
                logger.warn("The file {} is not exist", (Object)url);
                throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (!response.isSuccessful()) {
                String message = response.message();
                logger.warn("fail to download the file from {} because of {} and code {}", url, message, code);
                throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
            }
            if (!destPath.getParentFile().exists()) {
                destPath.getParentFile().mkdirs();
            }
            byte[] buf = new byte[4096];
            try (InputStream bs = Objects.requireNonNull(response.body()).byteStream();){
                int len = bs.read(buf);
                try (FileOutputStream fos = new FileOutputStream(destPath);){
                    while (len != -1) {
                        fos.write(buf, 0, len);
                        len = bs.read(buf);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void downloadFile(Response response, File destPath) {
        int code = response.code();
        if (response.code() == 304) {
            logger.info("file is newest, do not download to {}", (Object)destPath);
            return;
        }
        if (!response.isSuccessful()) {
            String message = response.message();
            logger.warn("fail to download the file because of {} and code {}", (Object)message, (Object)code);
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (!destPath.getParentFile().exists()) {
            destPath.getParentFile().mkdirs();
        }
        byte[] buf = new byte[4096];
        try (InputStream bs = Objects.requireNonNull(response.body()).byteStream();){
            int len = bs.read(buf);
            try (FileOutputStream fos = new FileOutputStream(destPath);){
                while (len != -1) {
                    fos.write(buf, 0, len);
                    len = bs.read(buf);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        OkHttpUtils.trustAllCerts[0] = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

