/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.utils.json;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.utils.json.JsonMapper;
import com.tencent.bk.devops.atom.utils.json.annotation.SkipLogField;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;

public class JsonUtil {
    private static final Map<String, JsonMapper> jsonMappers = Maps.newConcurrentMap();

    public static <T> String skipLogFields(T bean) {
        return jsonMappers.computeIfAbsent("__skipLogFields__" + bean.getClass().getName(), s -> {
            JsonMapper nonEmptyMapper = JsonMapper.nonEmptyMapper();
            HashSet<String> skipFields = new HashSet<String>();
            for (Class<?> aClass = bean.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = aClass.getDeclaredFields()) {
                    SkipLogField fieldAnnotation = field.getAnnotation(SkipLogField.class);
                    if (fieldAnnotation == null) continue;
                    if (fieldAnnotation.value().trim().length() > 0) {
                        skipFields.add(fieldAnnotation.value());
                        continue;
                    }
                    skipFields.add(field.getName());
                }
            }
            if (!skipFields.isEmpty()) {
                nonEmptyMapper.getMapper().addMixIn(bean.getClass(), SkipLogField.class);
                SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(SkipLogField.class.getAnnotation(JsonFilter.class).value(), SimpleBeanPropertyFilter.serializeAllExcept(skipFields));
                nonEmptyMapper.getMapper().setFilterProvider((FilterProvider)filterProvider);
            }
            return nonEmptyMapper;
        }).toJson(bean);
    }

    public static <T> T fromJson(String jsonString, TypeReference<T> typeReference) {
        return jsonMappers.computeIfAbsent("__all__", s -> JsonMapper.allOutPutMapper()).fromJson(jsonString, typeReference);
    }

    public static <T> T fromJson(String jsonString, Class<T> beanClass) {
        return jsonMappers.computeIfAbsent("__all__", s -> JsonMapper.allOutPutMapper()).fromJson(jsonString, beanClass);
    }

    public static <T> T fromJson(String jsonString) {
        return jsonMappers.computeIfAbsent("__all__", s -> JsonMapper.allOutPutMapper()).fromJson(jsonString, new TypeReference<T>(){});
    }

    public static <T> String toJson(T bean) {
        return jsonMappers.computeIfAbsent("__all__", s -> JsonMapper.allOutPutMapper()).toJson(bean);
    }

    public static <T> String toNonEmptyJson(T bean) {
        return jsonMappers.computeIfAbsent("__non_empty__", s -> JsonMapper.nonEmptyMapper()).toJson(bean);
    }
}

