/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.tencent.bk.devops.atom.api.BaseApi;
import com.tencent.bk.devops.atom.pojo.Result;
import com.tencent.bk.devops.plugin.docker.CommonExecutor;
import com.tencent.bk.devops.plugin.docker.ThirdPartExecutor;
import com.tencent.bk.devops.plugin.docker.exception.DockerRunException;
import com.tencent.bk.devops.plugin.docker.exception.DockerRunLogException;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000fJ*\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/tencent/bk/devops/plugin/docker/DockerApi;", "Lcom/tencent/bk/devops/atom/api/BaseApi;", "()V", "dockerRunCommand", "Lcom/tencent/bk/devops/atom/pojo/Result;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "projectId", "", "pipelineId", "buildId", "param", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "dockerRunCustomize", "dockerRunGetLog", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "dockerRunGetLogCustomize", "Companion", "java-plugin-sdk"})
public class DockerApi
extends BaseApi {
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final Result<DockerRunResponse> dockerRunCommand(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest param) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        try {
            String property = System.getenv("devops_slave_model");
            DockerRunResponse response = this.dockerRunCustomize(projectId, pipelineId, buildId, param);
            if (response == null) {
                response = Intrinsics.areEqual((Object)"docker", (Object)property) ? CommonExecutor.INSTANCE.execute(projectId, pipelineId, buildId, param) : ThirdPartExecutor.INSTANCE.execute(param);
            }
            return new Result<DockerRunResponse>(response);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new DockerRunException(string, 0, 2, null);
        }
    }

    @Nullable
    public DockerRunResponse dockerRunCustomize(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest param) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return null;
    }

    @NotNull
    public final Result<DockerRunLogResponse> dockerRunGetLog(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunLogRequest param) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        try {
            String property = System.getenv("devops_slave_model");
            DockerRunLogResponse response = this.dockerRunGetLogCustomize(projectId, pipelineId, buildId, param);
            if (response == null) {
                response = Intrinsics.areEqual((Object)"docker", (Object)property) ? CommonExecutor.INSTANCE.getLogs(projectId, pipelineId, buildId, param) : ThirdPartExecutor.INSTANCE.getLogs(param);
            }
            return new Result<DockerRunLogResponse>(response);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new DockerRunLogException(string, 0, 2, null);
        }
    }

    @Nullable
    public DockerRunLogResponse dockerRunGetLogCustomize(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunLogRequest param) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return null;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DockerApi.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tencent/bk/devops/plugin/docker/DockerApi$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "java-plugin-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

