/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/tencent/bk/devops/plugin/script/SensitiveLineParser;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pattern", "Ljava/util/regex/Pattern;", "patternPassword", "onParseLine", "", "line", "java-plugin-sdk"})
public final class SensitiveLineParser {
    private static final Pattern pattern;
    private static final Pattern patternPassword;
    private static final Logger logger;
    public static final SensitiveLineParser INSTANCE;

    @NotNull
    public final String onParseLine(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"http://oauth2:", (boolean)false, (int)2, null)) {
            Matcher matcher = pattern.matcher(line);
            String replace = matcher.replaceAll("oauth2:***@");
            logger.info("Parse the line from " + line + " to " + replace);
            String string = replace;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"replace");
            return string;
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"http://", (boolean)false, (int)2, null)) {
            String string = patternPassword.matcher(line).replaceAll("http://***:***@");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"patternPassword.matcher(\u2026aceAll(\"http://***:***@\")");
            return string;
        }
        return line;
    }

    private SensitiveLineParser() {
    }

    static {
        SensitiveLineParser sensitiveLineParser;
        INSTANCE = sensitiveLineParser = new SensitiveLineParser();
        pattern = Pattern.compile("oauth2:(\\w+)@");
        patternPassword = Pattern.compile("http://.*:.*@");
        logger = LoggerFactory.getLogger(SensitiveLineParser.class);
    }
}

