/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.utils;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.utils.json.annotation.SkipLogField;
import com.tencent.bk.devops.plugin.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0006J3\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u0005\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\u0012\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0014\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0018\u00a2\u0006\u0002\u0010\u0019J'\u0010\u0014\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0001J\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0001J\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0001J+\u0010\u001e\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/tencent/bk/devops/plugin/utils/JsonUtil;", "", "()V", "jsonMappers", "", "", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper", "skipEmptyObjectMapper", "getObjectMapper", "mapTo", "T", "map", "", "type", "Ljava/lang/Class;", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "skipLogFields", "bean", "(Ljava/lang/Object;)Ljava/lang/String;", "to", "json", "(Ljava/lang/String;)Ljava/lang/Object;", "typeReference", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "toJson", "toMap", "toMutableMapSkipEmpty", "toOrNull", "java-plugin-sdk"})
public final class JsonUtil {
    private static final ObjectMapper objectMapper;
    private static final ObjectMapper skipEmptyObjectMapper;
    private static final Map<String, ObjectMapper> jsonMappers;
    public static final JsonUtil INSTANCE;

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @Nullable
    public final <T> String skipLogFields(@NotNull T bean) {
        Intrinsics.checkParameterIsNotNull(bean, (String)"bean");
        return jsonMappers.computeIfAbsent("__skipLogFields__" + bean.getClass().getName(), new Function<String, ObjectMapper>(bean){
            final /* synthetic */ Object $bean;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ObjectMapper apply(@Nullable String s) {
                void var2_2;
                Object fields;
                ObjectMapper nonEmptyMapper = new ObjectMapper();
                Set skipFields = new HashSet<E>();
                for (Class<?> aClass = this.$bean.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                    for (Object field : fields = aClass.getDeclaredFields()) {
                        SkipLogField fieldAnnotation;
                        if (((Field)field).getAnnotation(SkipLogField.class) == null) {
                            continue;
                        }
                        CharSequence charSequence = fieldAnnotation.value();
                        boolean bl = false;
                        String string = charSequence;
                        if (string == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        bl = false;
                        if (charSequence.length() > 0) {
                            skipFields.add(fieldAnnotation.value());
                            continue;
                        }
                        Object object = field;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"field");
                        String string2 = ((Field)object).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"field.name");
                        skipFields.add(string2);
                    }
                }
                fields = skipFields;
                boolean bl = false;
                if (!fields.isEmpty()) {
                    nonEmptyMapper.addMixIn(this.$bean.getClass(), SkipLogField.class);
                    SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().addFilter(SkipLogField.class.getAnnotation(JsonFilter.class).value(), SimpleBeanPropertyFilter.serializeAllExcept((Set)skipFields));
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleFilterProvider, (String)"SimpleFilterProvider()\n \u2026izeAllExcept(skipFields))");
                    FilterProvider filterProvider = (FilterProvider)simpleFilterProvider;
                    nonEmptyMapper.setFilterProvider(filterProvider);
                }
                return var2_2;
            }
            {
                this.$bean = object;
            }
        }).writeValueAsString(bean);
    }

    @NotNull
    public final String toJson(@NotNull Object bean) {
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        if (ReflectUtil.INSTANCE.isNativeType(bean) || bean instanceof String) {
            return bean.toString();
        }
        String string = this.getObjectMapper().writeValueAsString(bean);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public final Map<String, Object> toMutableMapSkipEmpty(@NotNull Object bean) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        if (ReflectUtil.INSTANCE.isNativeType(bean)) {
            boolean bl = false;
            return new LinkedHashMap();
        }
        if (bean instanceof String) {
            Object object = skipEmptyObjectMapper.readValue(bean.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"skipEmptyObjectMapper.re\u2026leMap<String, Any>>() {})");
            map = (Map)object;
        } else {
            Object object = skipEmptyObjectMapper.readValue(skipEmptyObjectMapper.writeValueAsString(bean), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"skipEmptyObjectMapper.re\u2026leMap<String, Any>>() {})");
            map = (Map)object;
        }
        return map;
    }

    @NotNull
    public final Map<String, Object> toMap(@NotNull Object bean) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        if (ReflectUtil.INSTANCE.isNativeType(bean)) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        } else if (bean instanceof String) {
            map = (Map)this.to((String)bean);
        } else {
            String string = this.getObjectMapper().writeValueAsString(bean);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getObjectMapper().writeValueAsString(bean)");
            map = (Map)this.to(string);
        }
        return map;
    }

    public final <T> T to(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return (T)this.getObjectMapper().readValue(json, new TypeReference<T>(){});
    }

    public final <T> T to(@NotNull String json, @NotNull TypeReference<T> typeReference) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(typeReference, (String)"typeReference");
        return (T)this.getObjectMapper().readValue(json, typeReference);
    }

    public final <T> T to(@NotNull String json, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return (T)this.getObjectMapper().readValue(json, type);
    }

    @Nullable
    public final <T> T toOrNull(@Nullable String json, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        CharSequence charSequence = json;
        boolean bl = false;
        boolean bl2 = false;
        return (T)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : this.getObjectMapper().readValue(json, type));
    }

    public final <T> T mapTo(@NotNull Map<String, ? extends Object> map, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return (T)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString(map), type);
    }

    private JsonUtil() {
    }

    static {
        JsonUtil jsonUtil;
        INSTANCE = jsonUtil = new JsonUtil();
        ObjectMapper objectMapper = new ObjectMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        $this$apply.registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
        $this$apply.configure(SerializationFeature.INDENT_OUTPUT, true);
        $this$apply.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        $this$apply.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        $this$apply.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        $this$apply.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        $this$apply.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JsonUtil.objectMapper = objectMapper;
        objectMapper = new ObjectMapper();
        bl = false;
        bl2 = false;
        $this$apply = objectMapper;
        boolean bl4 = false;
        $this$apply.registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
        $this$apply.configure(SerializationFeature.INDENT_OUTPUT, true);
        $this$apply.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        $this$apply.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        $this$apply.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        $this$apply.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        $this$apply.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        skipEmptyObjectMapper = objectMapper;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"Maps.newConcurrentMap()");
        jsonMappers = concurrentMap;
    }
}

