/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.bk.devops.atom.api.SdkEnv;
import com.tencent.bk.devops.atom.pojo.Result;
import com.tencent.bk.devops.atom.utils.http.OkHttpUtils;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0007J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/tencent/bk/devops/plugin/docker/CommonExecutor;", "", "()V", "ONE_MILL_SECONDS", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "projectId", "", "pipelineId", "buildId", "request", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "taskId", "getLogs", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "getRunParamJson", "param", "trimLogs", "", "list", "DockerRunParam", "LogParam", "java-plugin-sdk"})
public final class CommonExecutor {
    private static final Logger logger;
    private static final int ONE_MILL_SECONDS = 1000;
    public static final CommonExecutor INSTANCE;

    @JvmOverloads
    @NotNull
    public final DockerRunResponse execute(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest request, @Nullable String taskId) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String runParam = this.getRunParamJson(request);
        String dockerHostIP = System.getenv("docker_host_ip");
        String string = System.getenv("docker_host_port");
        if (string == null) {
            string = "80";
        }
        String dockerHostPort = string;
        String vmSeqId = SdkEnv.getVmSeqId();
        String string2 = taskId;
        String dockerRunUrl = string2 == null ? "http://" + dockerHostIP + ':' + dockerHostPort + "/api/docker/run/" + projectId + '/' + pipelineId + '/' + vmSeqId + '/' + buildId : "http://" + dockerHostIP + ':' + dockerHostPort + "/api/docker/run/" + projectId + '/' + pipelineId + '/' + vmSeqId + '/' + buildId + "?taskId=" + taskId;
        logger.info("execute docker run url: " + dockerRunUrl);
        String responseContent = OkHttpUtils.doPost(dockerRunUrl, runParam);
        logger.info("execute docker run response: " + responseContent);
        Map extraOptions2 = (Map)((Result)JsonUtil.fromJson((String)responseContent, (TypeReference)new TypeReference<Result<Map<String, ? extends Object>>>(){})).data;
        return new DockerRunResponse(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"containerId", (Object)String.valueOf(extraOptions2.get("containerId"))), TuplesKt.to((Object)"startTimeStamp", (Object)String.valueOf(extraOptions2.get("startTimeStamp")))}));
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ DockerRunResponse execute$default(CommonExecutor commonExecutor, String string, String string2, String string3, DockerRunRequest dockerRunRequest, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        return commonExecutor.execute(string, string2, string3, dockerRunRequest, string4);
    }

    @JvmOverloads
    @NotNull
    public final DockerRunResponse execute(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest request) {
        return CommonExecutor.execute$default(this, projectId, pipelineId, buildId, request, null, 16, null);
    }

    @NotNull
    public final DockerRunLogResponse getLogs(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunLogRequest request) {
        DockerRunLogResponse dockerRunLogResponse;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String containerId = (String)MapsKt.getValue(request.getExtraOptions(), (Object)"containerId");
        String startTimeStamp = (String)MapsKt.getValue(request.getExtraOptions(), (Object)"startTimeStamp");
        String dockerHostIP = System.getenv("docker_host_ip");
        String string = System.getenv("docker_host_port");
        if (string == null) {
            string = "80";
        }
        String dockerHostPort = string;
        String vmSeqId = SdkEnv.getVmSeqId();
        String dockerGetLogUrl = "http://" + dockerHostIP + ':' + dockerHostPort + "/api/docker/runlog/" + projectId + '/' + pipelineId + '/' + vmSeqId + '/' + buildId + '/' + containerId + '/' + startTimeStamp;
        String logResponse = OkHttpUtils.doGet(dockerGetLogUrl);
        LogParam logParam = (LogParam)((Result)JsonUtil.fromJson((String)logResponse, (TypeReference)new TypeReference<Result<LogParam>>(){})).data;
        if (logParam == null) {
            return new DockerRunLogResponse(null, "failure", "the log data is null with get http: " + dockerGetLogUrl, request.getExtraOptions(), 1, null);
        }
        LogParam logResult2 = logParam;
        if (Intrinsics.areEqual((Object)logResult2.getRunning(), (Object)true) ^ true) {
            Integer n = logResult2.getExitCode();
            dockerRunLogResponse = n != null && n == 0 ? new DockerRunLogResponse(this.trimLogs(logResult2.getLogs()), "success", "the Docker Run Log is listed as follows:", request.getExtraOptions()) : new DockerRunLogResponse(this.trimLogs(logResult2.getLogs()), "failure", "the Docker Run Log is listed as follows:", request.getExtraOptions());
        } else {
            String string2 = startTimeStamp;
            String string3 = "startTimeStamp";
            Map<String, String> map = request.getExtraOptions();
            String string4 = "get log...";
            String string5 = "running";
            List<String> list = logResult2.getLogs();
            boolean bl = false;
            long l = Long.parseLong(string2);
            Map map2 = MapsKt.plus(map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)string3, (Object)String.valueOf(l + request.getTimeGap() / (long)1000))));
            String string6 = string4;
            String string7 = string5;
            List<String> list2 = list;
            dockerRunLogResponse = new DockerRunLogResponse(list2, string7, string6, map2);
        }
        return dockerRunLogResponse;
    }

    private final String getRunParamJson(DockerRunRequest param) {
        List list;
        boolean bl = false;
        boolean bl2 = false;
        DockerRunRequest $this$with = param;
        boolean bl3 = false;
        boolean bl4 = false;
        List cmdTmp = new ArrayList();
        Iterable $this$forEach$iv = $this$with.getCommand();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl5 = false;
            cmdTmp.add(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"\""), (CharSequence)"\""), (CharSequence)"'"), (CharSequence)"'"));
        }
        if (cmdTmp.size() == 1) {
            Object[] objectArray = Commandline.translateCommandline((String)((String)CollectionsKt.first((List)cmdTmp)));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Commandline.translateCommandline(cmdTmp.first())");
            list = ArraysKt.toList((Object[])objectArray);
        } else {
            list = cmdTmp;
        }
        List cmd = list;
        String string = $this$with.getImageName();
        String string2 = param.getDockerLoginUsername();
        String string3 = param.getDockerLoginPassword();
        List list2 = cmd;
        Map map = $this$with.getEnvMap();
        if (map == null) {
            List list3 = list2;
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            boolean bl6 = false;
            Map map2 = MapsKt.emptyMap();
            string = string6;
            string2 = string5;
            string3 = string4;
            list2 = list3;
            map = map2;
        }
        String string7 = System.getenv("pool_no");
        Map map3 = map;
        List list4 = list2;
        String string8 = string3;
        String string9 = string2;
        String string10 = string;
        DockerRunParam runParam = new DockerRunParam(string10, string9, string8, list4, map3, string7);
        logger.info("execute docker run image: " + runParam);
        String string11 = JsonUtil.toJson(runParam);
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"JsonUtil.toJson(runParam)");
        return string11;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> trimLogs(List<String> list) {
        List list2;
        List<String> list3 = list;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String[] split;
                Collection thisCollection$iv;
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CharSequence charSequence = (CharSequence)it;
                String string3 = "\\s+";
                int n = 0;
                string3 = new Regex(string3);
                n = 0;
                boolean bl2 = false;
                Collection $this$toTypedArray$iv = string3.split(charSequence, n);
                boolean $i$f$toTypedArray = false;
                if ($this$toTypedArray$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                if (split.length >= 3) {
                    void var12_14 = it;
                    int n2 = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (String)split[2], (int)0, (boolean)false, (int)6, null);
                    bl2 = false;
                    void v1 = var12_14;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = v1.substring(n2);
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string = it;
                }
                void log = string;
                void var17_21 = log;
                collection.add(var17_21);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private CommonExecutor() {
    }

    static {
        CommonExecutor commonExecutor;
        INSTANCE = commonExecutor = new CommonExecutor();
        logger = LoggerFactory.getLogger(CommonExecutor.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J_\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\b\u0010!\u001a\u00020\u0003H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/tencent/bk/devops/plugin/docker/CommonExecutor$DockerRunParam;", "", "imageName", "", "registryUser", "registryPwd", "command", "", "env", "", "poolNo", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;)V", "getCommand", "()Ljava/util/List;", "getEnv", "()Ljava/util/Map;", "getImageName", "()Ljava/lang/String;", "getPoolNo", "getRegistryPwd", "getRegistryUser", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "java-plugin-sdk"})
    private static final class DockerRunParam {
        @Nullable
        private final String imageName;
        @Nullable
        private final String registryUser;
        @Nullable
        private final String registryPwd;
        @NotNull
        private final List<String> command;
        @NotNull
        private final Map<String, String> env;
        @Nullable
        private final String poolNo;

        @NotNull
        public String toString() {
            return "image name: " + this.imageName + ", registry user: " + this.registryUser + ", " + "command: " + this.command + ", env: " + this.env + ", pool no: " + this.poolNo;
        }

        @Nullable
        public final String getImageName() {
            return this.imageName;
        }

        @Nullable
        public final String getRegistryUser() {
            return this.registryUser;
        }

        @Nullable
        public final String getRegistryPwd() {
            return this.registryPwd;
        }

        @NotNull
        public final List<String> getCommand() {
            return this.command;
        }

        @NotNull
        public final Map<String, String> getEnv() {
            return this.env;
        }

        @Nullable
        public final String getPoolNo() {
            return this.poolNo;
        }

        public DockerRunParam(@Nullable String imageName, @Nullable String registryUser, @Nullable String registryPwd, @NotNull List<String> command, @NotNull Map<String, String> env, @Nullable String poolNo) {
            Intrinsics.checkParameterIsNotNull(command, (String)"command");
            Intrinsics.checkParameterIsNotNull(env, (String)"env");
            this.imageName = imageName;
            this.registryUser = registryUser;
            this.registryPwd = registryPwd;
            this.command = command;
            this.env = env;
            this.poolNo = poolNo;
        }

        @Nullable
        public final String component1() {
            return this.imageName;
        }

        @Nullable
        public final String component2() {
            return this.registryUser;
        }

        @Nullable
        public final String component3() {
            return this.registryPwd;
        }

        @NotNull
        public final List<String> component4() {
            return this.command;
        }

        @NotNull
        public final Map<String, String> component5() {
            return this.env;
        }

        @Nullable
        public final String component6() {
            return this.poolNo;
        }

        @NotNull
        public final DockerRunParam copy(@Nullable String imageName, @Nullable String registryUser, @Nullable String registryPwd, @NotNull List<String> command, @NotNull Map<String, String> env, @Nullable String poolNo) {
            Intrinsics.checkParameterIsNotNull(command, (String)"command");
            Intrinsics.checkParameterIsNotNull(env, (String)"env");
            return new DockerRunParam(imageName, registryUser, registryPwd, command, env, poolNo);
        }

        @NotNull
        public static /* synthetic */ DockerRunParam copy$default(DockerRunParam dockerRunParam, String string, String string2, String string3, List list, Map map, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dockerRunParam.imageName;
            }
            if ((n & 2) != 0) {
                string2 = dockerRunParam.registryUser;
            }
            if ((n & 4) != 0) {
                string3 = dockerRunParam.registryPwd;
            }
            if ((n & 8) != 0) {
                list = dockerRunParam.command;
            }
            if ((n & 0x10) != 0) {
                map = dockerRunParam.env;
            }
            if ((n & 0x20) != 0) {
                string4 = dockerRunParam.poolNo;
            }
            return dockerRunParam.copy(string, string2, string3, list, map, string4);
        }

        public int hashCode() {
            String string = this.imageName;
            String string2 = this.registryUser;
            String string3 = this.registryPwd;
            List<String> list = this.command;
            Map<String, String> map = this.env;
            String string4 = this.poolNo;
            return (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DockerRunParam)) break block3;
                    DockerRunParam dockerRunParam = (DockerRunParam)object;
                    if (!Intrinsics.areEqual((Object)this.imageName, (Object)dockerRunParam.imageName) || !Intrinsics.areEqual((Object)this.registryUser, (Object)dockerRunParam.registryUser) || !Intrinsics.areEqual((Object)this.registryPwd, (Object)dockerRunParam.registryPwd) || !Intrinsics.areEqual(this.command, dockerRunParam.command) || !Intrinsics.areEqual(this.env, dockerRunParam.env) || !Intrinsics.areEqual((Object)this.poolNo, (Object)dockerRunParam.poolNo)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J8\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/tencent/bk/devops/plugin/docker/CommonExecutor$LogParam;", "", "exitCode", "", "logs", "", "", "running", "", "(Ljava/lang/Integer;Ljava/util/List;Ljava/lang/Boolean;)V", "getExitCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLogs", "()Ljava/util/List;", "getRunning", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "copy", "(Ljava/lang/Integer;Ljava/util/List;Ljava/lang/Boolean;)Lcom/tencent/bk/devops/plugin/docker/CommonExecutor$LogParam;", "equals", "other", "hashCode", "toString", "java-plugin-sdk"})
    public static final class LogParam {
        @Nullable
        private final Integer exitCode;
        @Nullable
        private final List<String> logs;
        @Nullable
        private final Boolean running;

        @Nullable
        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Nullable
        public final List<String> getLogs() {
            return this.logs;
        }

        @Nullable
        public final Boolean getRunning() {
            return this.running;
        }

        public LogParam(@Nullable Integer exitCode, @Nullable List<String> logs, @Nullable Boolean running) {
            this.exitCode = exitCode;
            this.logs = logs;
            this.running = running;
        }

        public /* synthetic */ LogParam(Integer n, List list, Boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            if ((n2 & 2) != 0) {
                list = null;
            }
            if ((n2 & 4) != 0) {
                bl = null;
            }
            this(n, list, bl);
        }

        public LogParam() {
            this(null, null, null, 7, null);
        }

        @Nullable
        public final Integer component1() {
            return this.exitCode;
        }

        @Nullable
        public final List<String> component2() {
            return this.logs;
        }

        @Nullable
        public final Boolean component3() {
            return this.running;
        }

        @NotNull
        public final LogParam copy(@Nullable Integer exitCode, @Nullable List<String> logs, @Nullable Boolean running) {
            return new LogParam(exitCode, logs, running);
        }

        @NotNull
        public static /* synthetic */ LogParam copy$default(LogParam logParam, Integer n, List list, Boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = logParam.exitCode;
            }
            if ((n2 & 2) != 0) {
                list = logParam.logs;
            }
            if ((n2 & 4) != 0) {
                bl = logParam.running;
            }
            return logParam.copy(n, list, bl);
        }

        @NotNull
        public String toString() {
            return "LogParam(exitCode=" + this.exitCode + ", logs=" + this.logs + ", running=" + this.running + ")";
        }

        public int hashCode() {
            Integer n = this.exitCode;
            List<String> list = this.logs;
            Boolean bl = this.running;
            return ((n != null ? ((Object)n).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (bl != null ? ((Object)bl).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LogParam)) break block3;
                    LogParam logParam = (LogParam)object;
                    if (!Intrinsics.areEqual((Object)this.exitCode, (Object)logParam.exitCode) || !Intrinsics.areEqual(this.logs, logParam.logs) || !Intrinsics.areEqual((Object)this.running, (Object)logParam.running)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

