/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import com.tencent.bk.devops.plugin.docker.exception.DockerPullException;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import com.tencent.bk.devops.plugin.docker.utils.ParamUtils;
import com.tencent.bk.devops.plugin.script.ScriptUtils;
import com.tencent.bk.devops.plugin.utils.MachineEnvUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0016\u001a\u00020\u000b2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tencent/bk/devops/plugin/docker/ThirdPartExecutor;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "doDockerPull", "", "param", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "doDockerRun", "", "dockerLogin", "dockerLogout", "dockerRm", "containerId", "workspace", "Ljava/io/File;", "execute", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "getContainerStatus", "Lkotlin/Pair;", "getEnvVar", "envMap", "", "getLogs", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "java-plugin-sdk"})
public final class ThirdPartExecutor {
    private static final Logger logger;
    public static final ThirdPartExecutor INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DockerRunResponse execute(@NotNull DockerRunRequest param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        boolean bl = false;
        boolean bl2 = false;
        DockerRunRequest $this$with = param;
        boolean bl3 = false;
        try {
            INSTANCE.dockerLogin($this$with);
            INSTANCE.doDockerPull($this$with);
            String containerId = INSTANCE.doDockerRun($this$with);
            DockerRunResponse dockerRunResponse = new DockerRunResponse(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"startTimestamp", (Object)String.valueOf(System.currentTimeMillis())), TuplesKt.to((Object)"dockerContainerId", (Object)containerId)}));
            return dockerRunResponse;
        }
        finally {
            INSTANCE.dockerLogout($this$with);
        }
    }

    private final String doDockerRun(DockerRunRequest param) {
        String string;
        if (Intrinsics.areEqual((Object)MachineEnvUtils.INSTANCE.getOS(), (Object)"WINDOWS")) {
            StringBuilder stringBuilder = new StringBuilder().append("/");
            String string2 = param.getWorkspace().getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"param.workspace.canonicalPath");
            string = stringBuilder.append(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)":", (String)"", (boolean)false, (int)4, null)).toString();
        } else {
            string = param.getWorkspace().getCanonicalPath();
        }
        String dockerWorkspace = string;
        String command = "docker run -d -v " + dockerWorkspace + ':' + dockerWorkspace + ' ' + this.getEnvVar(param.getEnvMap()) + ' ' + param.getImageName() + ' ' + CollectionsKt.joinToString$default((Iterable)param.getCommand(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        logger.info("execute command: " + command);
        return ScriptUtils.execute$default(ScriptUtils.INSTANCE, command, param.getWorkspace(), null, null, false, false, 60, null);
    }

    private final synchronized void doDockerPull(DockerRunRequest param) {
        try {
            String pullCmd = "docker pull " + param.getImageName();
            ScriptUtils.execute$default(ScriptUtils.INSTANCE, pullCmd, param.getWorkspace(), null, null, false, false, 60, null);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw (Throwable)new DockerPullException(string, 0, 2, null);
        }
    }

    private final String getEnvVar(Map<String, String> envMap) {
        StringBuilder command = new StringBuilder();
        Map<String, String> map = envMap;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<String, String> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl2 = false;
                command.append("--env " + it.getKey() + '=' + it.getValue() + ' ');
            }
        }
        String string = command.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"command.toString()");
        return string;
    }

    @NotNull
    public final DockerRunLogResponse getLogs(@NotNull DockerRunLogRequest param) {
        String command;
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String string = param.getExtraOptions().get("startTimestamp");
        if (string == null) {
            throw (Throwable)new RuntimeException("startTimestamp is null");
        }
        String string2 = string;
        boolean bl = false;
        long startTimestamp = Long.parseLong(string2);
        String string3 = param.getExtraOptions().get("dockerContainerId");
        if (string3 == null) {
            throw (Throwable)new RuntimeException("dockerContainerId is null");
        }
        String containerId = string3;
        Pair<String, String> statusPair = this.getContainerStatus(containerId, param.getWorkspace());
        String status = (String)statusPair.getFirst();
        String startTime = Intrinsics.areEqual((Object)status, (Object)"running") ? ParamUtils.INSTANCE.beiJ2UTC(startTimestamp) : (String)statusPair.getSecond();
        String preStartTime = ParamUtils.INSTANCE.beiJ2UTC(startTimestamp - param.getTimeGap());
        boolean failToGetLog = false;
        String errorMessage = "";
        try {
            command = "docker logs --until=\"" + startTime + "\" --since=\"" + preStartTime + "\" " + containerId;
            command = ScriptUtils.execute$default(ScriptUtils.INSTANCE, command, param.getWorkspace(), null, null, false, false, 44, null);
        }
        catch (Exception e) {
            String string4 = e.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            errorMessage = string4;
            failToGetLog = true;
            command = "";
        }
        String log = command;
        if (Intrinsics.areEqual((Object)status, (Object)"running") ^ true) {
            if (failToGetLog) {
                logger.error("fail to get log: " + errorMessage);
                command = "docker logs " + containerId;
                log = ScriptUtils.execute$default(ScriptUtils.INSTANCE, command, param.getWorkspace(), null, null, false, false, 12, null);
            }
            this.dockerRm(containerId, param.getWorkspace());
        }
        return new DockerRunLogResponse(CollectionsKt.listOf((Object)log), status, "get log...", MapsKt.plus(param.getExtraOptions(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"startTimestamp", (Object)String.valueOf(startTimestamp + param.getTimeGap())))));
    }

    private final Pair<String, String> getContainerStatus(String containerId, File workspace) {
        String inspectResult = ScriptUtils.execute$default(ScriptUtils.INSTANCE, "docker inspect " + containerId, workspace, null, null, false, false, 44, null);
        Object t = JsonUtil.fromJson(inspectResult);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"JsonUtil.fromJson<List<M\u2026ng, Any>>>(inspectResult)");
        Map inspectMap = (Map)CollectionsKt.first((List)((List)t));
        Object v = inspectMap.get("State");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        Map state = (Map)v;
        Object v2 = state.get("Status");
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String status = (String)v2;
        if (Intrinsics.areEqual((Object)status, (Object)"running")) {
            return new Pair((Object)"running", (Object)"");
        }
        Object v3 = state.get("ExitCode");
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int exitCode = (Integer)v3;
        Object v4 = state.get("FinishedAt");
        if (v4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String finishedAt = (String)v4;
        return exitCode != 0 ? new Pair((Object)"failure", (Object)finishedAt) : new Pair((Object)"success", (Object)finishedAt);
    }

    private final void dockerRm(String containerId, File workspace) {
        String cmd = "docker rm " + containerId;
        logger.info("[execute script]: " + cmd);
        ScriptUtils.execute$default(ScriptUtils.INSTANCE, cmd, workspace, null, null, false, false, 28, null);
    }

    private final synchronized void dockerLogin(DockerRunRequest param) {
        CharSequence charSequence = param.getDockerLoginUsername();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String username = param.getDockerLoginUsername();
        String password = param.getDockerLoginPassword();
        String loginHost = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)param.getImageName(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null));
        String commandStr = "docker login " + loginHost + " --username " + username + " --password " + password;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "docker login %s --username %s  --password ***";
        Object[] objectArray = new Object[]{loginHost, username};
        StringBuilder stringBuilder = new StringBuilder().append("[execute script]: ");
        Logger logger = ThirdPartExecutor.logger;
        boolean bl3 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        logger.info(stringBuilder.append(string3).toString());
        ScriptUtils.execute$default(ScriptUtils.INSTANCE, commandStr, param.getWorkspace(), null, null, false, false, 60, null);
    }

    private final synchronized void dockerLogout(DockerRunRequest param) {
        CharSequence charSequence = param.getDockerLoginUsername();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String loginHost = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)param.getImageName(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null));
        String commandStr = "docker logout " + loginHost;
        logger.info("[execute script]: " + commandStr);
        ScriptUtils.execute$default(ScriptUtils.INSTANCE, commandStr, param.getWorkspace(), null, null, false, false, 60, null);
    }

    private ThirdPartExecutor() {
    }

    static {
        ThirdPartExecutor thirdPartExecutor;
        INSTANCE = thirdPartExecutor = new ThirdPartExecutor();
        logger = LoggerFactory.getLogger(ThirdPartExecutor.class);
    }
}

