/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/tencent/bk/devops/plugin/docker/utils/EnvUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getHostName", "", "java-plugin-sdk"})
public final class EnvUtils {
    private static final Logger logger;
    public static final EnvUtils INSTANCE;

    @NotNull
    public final String getHostName() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null || StringUtils.isBlank((CharSequence)hostname)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getLocalHost()");
                hostname = inetAddress.getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        logger.info("env host name is: " + hostname);
        String string = hostname;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hostname");
        return string;
    }

    private EnvUtils() {
    }

    static {
        EnvUtils envUtils;
        INSTANCE = envUtils = new EnvUtils();
        logger = LoggerFactory.getLogger(EnvUtils.class);
    }
}

