/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import com.tencent.bk.devops.plugin.script.CommandLineExecutor;
import com.tencent.bk.devops.plugin.script.SensitiveLineParser;
import java.io.File;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/tencent/bk/devops/plugin/script/CommandLineUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "", "command", "workspace", "Ljava/io/File;", "print2Logger", "", "prefix", "printException", "java-plugin-sdk"})
public final class CommandLineUtils {
    private static final Logger logger;
    public static final CommandLineUtils INSTANCE;

    @NotNull
    public final String execute(@NotNull String command, @Nullable File workspace, boolean print2Logger, @NotNull String prefix, boolean printException) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        StringBuffer result = new StringBuffer();
        CommandLine cmdLine = CommandLine.parse((String)command);
        CommandLineExecutor executor = new CommandLineExecutor();
        if (workspace != null) {
            executor.setWorkingDirectory(workspace);
        }
        LogOutputStream outputStream2 = new LogOutputStream(prefix, print2Logger, result){
            final /* synthetic */ String $prefix;
            final /* synthetic */ boolean $print2Logger;
            final /* synthetic */ StringBuffer $result;

            protected void processLine(@Nullable String line, int level) {
                if (line == null) {
                    return;
                }
                String tmpLine = SensitiveLineParser.INSTANCE.onParseLine(this.$prefix + line);
                if (this.$print2Logger) {
                    CommandLineUtils.access$getLogger$p(CommandLineUtils.INSTANCE).info(tmpLine);
                }
                this.$result.append(tmpLine).append("\n");
            }
            {
                this.$prefix = $captured_local_variable$0;
                this.$print2Logger = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
            }
        };
        LogOutputStream errorStream2 = new LogOutputStream(prefix, print2Logger, result){
            final /* synthetic */ String $prefix;
            final /* synthetic */ boolean $print2Logger;
            final /* synthetic */ StringBuffer $result;

            protected void processLine(@Nullable String line, int level) {
                if (line == null) {
                    return;
                }
                String tmpLine = SensitiveLineParser.INSTANCE.onParseLine(this.$prefix + line);
                if (this.$print2Logger) {
                    CommandLineUtils.access$getLogger$p(CommandLineUtils.INSTANCE).error(tmpLine);
                }
                this.$result.append(tmpLine).append("\n");
            }
            {
                this.$prefix = $captured_local_variable$0;
                this.$print2Logger = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
            }
        };
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outputStream2, (OutputStream)errorStream2));
        try {
            int exitCode = executor.execute(cmdLine);
            if (exitCode != 0) {
                throw (Throwable)new RuntimeException(prefix + " Script command execution failed with exit code(" + exitCode + ')');
            }
        }
        catch (Throwable t) {
            if (printException) {
                logger.warn("Fail to execute the command(" + command + ')', t);
            }
            if (print2Logger) {
                logger.error(prefix + " Fail to execute the command(" + command + "): " + t.getMessage());
            }
            throw t;
        }
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public static /* synthetic */ String execute$default(CommandLineUtils commandLineUtils, String string, File file, boolean bl, String string2, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return commandLineUtils.execute(string, file, bl, string2, bl2);
    }

    private CommandLineUtils() {
    }

    static {
        CommandLineUtils commandLineUtils;
        INSTANCE = commandLineUtils = new CommandLineUtils();
        logger = LoggerFactory.getLogger(CommandLineUtils.class);
    }

    public static final /* synthetic */ Logger access$getLogger$p(CommandLineUtils $this) {
        CommandLineUtils commandLineUtils = $this;
        return logger;
    }
}

