/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import com.tencent.bk.devops.plugin.script.CommandLineUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J6\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0002J4\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u0018J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/tencent/bk/devops/plugin/script/ShellUtil;", "", "()V", "GATEWAY_FILE", "", "WORKSPACE_ENV", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "setEnv", "setGateValue", "specialCharToReplace", "Lkotlin/text/Regex;", "specialKey", "", "specialValue", "execute", "script", "dir", "Ljava/io/File;", "runtimeVariables", "", "prefix", "printLog", "", "failExit", "executeUnixCommand", "command", "sourceDir", "getCommandFile", "specialEnv", "key", "value", "java-plugin-sdk"})
public final class ShellUtil {
    private static final String setEnv = "setEnv(){\n        local key=$1\n        local val=$2\n\n        if [[ -z \"$@\" ]]; then\n            return 0\n        fi\n\n        if ! echo \"$key\" | grep -qE \"^[a-zA-Z_][a-zA-Z0-9_]*$\"; then\n            echo \"[$key] is invalid\" >&2\n            return 1\n        fi\n\n        echo $key=$val  >> ##resultFile##\n        export $key=\"$val\"\n    }\n";
    private static final String setGateValue = "setGateValue(){\n        local key=$1\n        local val=$2\n\n        if [[ -z \"$@\" ]]; then\n            return 0\n        fi\n\n        if ! echo \"$key\" | grep -qE \"^[a-zA-Z_][a-zA-Z0-9_]*$\"; then\n            echo \"[$key] is invalid\" >&2\n            return 1\n        fi\n\n        echo $key=$val  >> ##gateValueFile##\n    }\n";
    @NotNull
    public static final String GATEWAY_FILE = "gatewayValueFile.ini";
    private static final List<String> specialKey;
    private static final List<String> specialValue;
    private static final Regex specialCharToReplace;
    private static final String WORKSPACE_ENV = "WORKSPACE";
    private static final Logger logger;
    public static final ShellUtil INSTANCE;

    @NotNull
    public final String execute(@NotNull String script, @NotNull File dir, @NotNull Map<String, String> runtimeVariables, @NotNull String prefix, boolean printLog, boolean failExit) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull(runtimeVariables, (String)"runtimeVariables");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        String string = ShellUtil.getCommandFile$default(this, script, dir, runtimeVariables, false, 8, null).getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getCommandFile(script, d\u2026eVariables).canonicalPath");
        return this.executeUnixCommand(string, dir, prefix, printLog, failExit);
    }

    @NotNull
    public static /* synthetic */ String execute$default(ShellUtil shellUtil, String string, File file, Map map, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return shellUtil.execute(string, file, map, string2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getCommandFile(@NotNull String script, @NotNull File dir, @NotNull Map<String, String> runtimeVariables, boolean failExit) {
        Map commonEnv;
        Map.Entry element$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull(runtimeVariables, (String)"runtimeVariables");
        File file = Files.createTempFile("devops_script", ".sh", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        StringBuilder command = new StringBuilder();
        String bashStr = (String)StringsKt.split$default((CharSequence)script, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null).get(0);
        if (StringsKt.startsWith$default((String)bashStr, (String)"#!/", (boolean)false, (int)2, null)) {
            command.append(bashStr).append("\n");
        }
        StringBuilder stringBuilder = command.append("export WORKSPACE=" + dir.getAbsolutePath() + '\n');
        StringBuilder stringBuilder2 = new StringBuilder().append("export DEVOPS_BUILD_SCRIPT_FILE=");
        File file2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        stringBuilder.append(stringBuilder2.append(file2.getAbsolutePath()).append('\n').toString());
        Map $this$filter$iv = runtimeVariables;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var14_15 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var14_15.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(!INSTANCE.specialEnv((String)it.getKey(), (String)it.getValue()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = commonEnv = destination$iv$iv;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty()) {
            Map $this$forEach$iv = commonEnv;
            boolean $i$f$forEach = false;
            map = $this$forEach$iv;
            boolean bl3 = false;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$name$value = element$iv = iterator2.next();
                boolean bl4 = false;
                element$iv$iv = $dstr$name$value;
                boolean bl5 = false;
                String name = (String)element$iv$iv.getKey();
                element$iv$iv = $dstr$name$value;
                bl5 = false;
                String value = (String)element$iv$iv.getValue();
                CharSequence charSequence = value;
                Regex regex = specialCharToReplace;
                String string = "";
                boolean bl6 = false;
                String clean = regex.replace(charSequence, string);
                command.append("export " + name + "='" + clean + "'\n");
            }
        }
        String string = new File(dir, "result.log").getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(dir, \"result.log\").absolutePath");
        command.append(StringsKt.replace$default((String)setEnv, (String)"##resultFile##", (String)string, (boolean)false, (int)4, null));
        String string2 = new File(dir, GATEWAY_FILE).getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File(dir, GATEWAY_FILE).absolutePath");
        command.append(StringsKt.replace$default((String)setGateValue, (String)"##gateValueFile##", (String)string2, (boolean)false, (int)4, null));
        command.append(script);
        String string3 = command.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"command.toString()");
        FilesKt.writeText$default((File)file, (String)string3, null, (int)2, null);
        ShellUtil.executeUnixCommand$default(this, "chmod +x " + file.getAbsolutePath(), dir, null, false, failExit, 12, null);
        return file;
    }

    @NotNull
    public static /* synthetic */ File getCommandFile$default(ShellUtil shellUtil, String string, File file, Map map, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return shellUtil.getCommandFile(string, file, map, bl);
    }

    private final String executeUnixCommand(String command, File sourceDir, String prefix, boolean printLog, boolean failExit) {
        String string;
        try {
            string = CommandLineUtils.execute$default(CommandLineUtils.INSTANCE, command, sourceDir, printLog, prefix, false, 16, null);
        }
        catch (Throwable ignored) {
            logger.error("Fail to run the command " + command + " because of error(" + ignored.getMessage() + ')');
            if (failExit) {
                throw ignored;
            }
            String string2 = ignored.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        return string;
    }

    static /* synthetic */ String executeUnixCommand$default(ShellUtil shellUtil, String string, File file, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return shellUtil.executeUnixCommand(string, file, string2, bl, bl2);
    }

    private final boolean specialEnv(String key, String value) {
        String it;
        Iterable $this$forEach$iv = specialKey;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)key, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return true;
        }
        $this$forEach$iv = specialValue;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)value, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private ShellUtil() {
    }

    static {
        ShellUtil shellUtil;
        INSTANCE = shellUtil = new ShellUtil();
        specialKey = CollectionsKt.listOf((Object[])new String[]{".", "-"});
        specialValue = CollectionsKt.listOf((Object[])new String[]{"|", "&", "(", ")"});
        specialCharToReplace = new Regex("['\n]");
        logger = LoggerFactory.getLogger(ShellUtil.class);
    }
}

