/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.bk.devops.atom.pojo.AtomBaseParam;
import com.tencent.bk.devops.atom.pojo.AtomResult;
import com.tencent.bk.devops.atom.utils.http.SdkUtils;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import com.tencent.bk.devops.plugin.api.impl.SensitiveConfApi;
import com.tencent.bk.devops.plugin.pojo.atom.SensitiveConfResp;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomContext<T extends AtomBaseParam> {
    private final String dataDir = SdkUtils.getDataDir();
    private final String inputFile = SdkUtils.getInputFile();
    private final String outputFile = SdkUtils.getOutputFile();
    private T param;
    private AtomResult result;
    private static final String ATOM_FILE_ENCODING = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(AtomContext.class);

    public AtomContext(Class<T> paramClazz) throws IOException {
        this.param = this.readParam(paramClazz);
        this.result = new AtomResult();
    }

    public T getParam() {
        return this.param;
    }

    public String getSensitiveConfParam(String filedName) {
        Map<String, String> bkSensitiveConfInfo = ((AtomBaseParam)this.param).getBkSensitiveConfInfo();
        if (null != bkSensitiveConfInfo) {
            return bkSensitiveConfInfo.get(filedName);
        }
        return null;
    }

    public AtomResult getResult() {
        return this.result;
    }

    private T readParam(Class<T> paramClazz) throws IOException {
        String json = FileUtils.readFileToString((File)new File(this.dataDir + "/" + this.inputFile), (String)ATOM_FILE_ENCODING);
        AtomBaseParam param = (AtomBaseParam)JsonUtil.fromJson(json, paramClazz);
        String atomCode = null;
        if (param != null) {
            atomCode = param.getAtomCode();
        }
        if (atomCode == null || !atomCode.equals(System.getenv("BK_CI_ATOM_CODE"))) {
            return (T)param;
        }
        SensitiveConfApi sensitiveConfApi = new SensitiveConfApi();
        List<SensitiveConfResp> sensitiveConfList = sensitiveConfApi.getAtomSensitiveConf(atomCode).getData();
        if (sensitiveConfList != null && !sensitiveConfList.isEmpty()) {
            HashMap<String, String> bkSensitiveConfInfo = new HashMap<String, String>();
            for (SensitiveConfResp sensitiveConfResp : sensitiveConfList) {
                bkSensitiveConfInfo.put(sensitiveConfResp.getFieldName(), sensitiveConfResp.getFieldValue());
            }
            param.setBkSensitiveConfInfo(bkSensitiveConfInfo);
        }
        return (T)param;
    }

    public Map<String, Object> getAllParameters() throws IOException {
        String json = FileUtils.readFileToString((File)new File(this.dataDir + "/" + this.inputFile), (String)ATOM_FILE_ENCODING);
        return JsonUtil.fromJson(json, new TypeReference<Map<String, Object>>(){});
    }

    void persistent() throws IOException {
        String json = JsonUtil.toJson(this.result);
        FileUtils.write((File)new File(this.dataDir + "/" + this.outputFile), (CharSequence)json, (String)ATOM_FILE_ENCODING);
    }
}

