/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.api;

import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.api.SdkEnv;
import com.tencent.bk.devops.atom.exception.RemoteServiceException;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpRetryException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseApi {
    protected static final MediaType JSON_CONTENT_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger(BaseApi.class);
    private static final long sleepTimeMills = 500L;
    private static final int DEFAULT_RETRY_TIME = 5;
    protected OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(1500L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();

    protected Response requestForResponse(Request request, int retryCount) throws IOException, InterruptedException {
        boolean retryFlag;
        OkHttpClient httpClient = this.okHttpClient.newBuilder().build();
        try {
            Response response = httpClient.newCall(request).execute();
            if (!Arrays.asList(502, 503, 504).contains(response.code())) {
                return response;
            }
            retryFlag = true;
        }
        catch (UnknownHostException e) {
            logger.warn("UnknownHostException|request({}),error is :{}, try to retry {}", request, e.getMessage(), retryCount);
            retryFlag = retryCount > 0;
        }
        catch (ConnectException e) {
            logger.warn("ConnectException|request({}),error is :{}, try to retry {}", request, e.getMessage(), retryCount);
            retryFlag = retryCount > 0;
        }
        catch (SocketTimeoutException re) {
            if ("connect timed out".equals(re.getMessage()) || "GET".equals(request.method()) && "timeout".equals(re.getMessage())) {
                logger.warn("SocketTimeoutException|request({}),error is :{}, try to retry {}", request, re.getMessage(), retryCount);
                retryFlag = retryCount > 0;
            }
            logger.error("Fail to request({})", (Object)request, (Object)re);
            throw re;
        }
        catch (Exception error) {
            logger.error("Fail to request({})", (Object)request, (Object)error);
            throw new RemoteServiceException(String.format("Fail to request(%s),error is:%s", request, error.getMessage()), 500, "");
        }
        if (retryFlag && retryCount > 0) {
            logger.warn("Fail to request({}), retry after {} ms", (Object)request, (Object)500L);
            Thread.sleep(500L);
            return this.requestForResponse(request, retryCount - 1);
        }
        logger.error("Fail to request({}), try to retry {}", (Object)request, (Object)retryCount);
        throw new HttpRetryException(String.format("Fail to request(%s), try to retry %s", request, retryCount), 999);
    }

    protected String retryRequest(Request request, String errorMessage, int retryCount) throws IOException {
        String string;
        block9: {
            Response response = this.requestForResponse(request, retryCount);
            try {
                String responseContent;
                String string2 = responseContent = response.body() != null ? response.body().string() : null;
                if (!response.isSuccessful()) {
                    logger.error("Fail to request(" + String.valueOf(request) + ") with code " + response.code() + " , message " + response.message() + " and response" + responseContent);
                    logger.info("excep>>>>>>>>>>>>" + String.valueOf(response));
                    throw new RemoteServiceException(errorMessage, response.code(), responseContent);
                }
                string = responseContent;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new RemoteServiceException(errorMessage, 500, e.getMessage());
                }
            }
            response.close();
        }
        return string;
    }

    protected String retryRequest(Request request, String errorMessage) throws IOException {
        return this.retryRequest(request, errorMessage, 5);
    }

    protected String request(Request request, String errorMessage) throws IOException {
        OkHttpClient httpClient = this.okHttpClient.newBuilder().build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseContent;
            String string = responseContent = response.body() != null ? response.body().string() : null;
            if (!response.isSuccessful()) {
                logger.error("Fail to request(" + String.valueOf(request) + ") with code " + response.code() + " , message " + response.message() + " and response" + responseContent);
                logger.info("excep>>>>>>>>>>>>" + String.valueOf(response));
                throw new RemoteServiceException(errorMessage, response.code(), responseContent);
            }
            String string2 = responseContent;
            return string2;
        }
    }

    public Request buildGet(String path, Map<String, String> headers) {
        String url = this.buildUrl(path);
        return new Request.Builder().url(url).headers(Headers.of(this.getAllHeaders(headers))).get().build();
    }

    public Request buildGet(String path) {
        return this.buildGet(path, Maps.newHashMap());
    }

    public Request buildPost(String path) {
        return this.buildPost(path, Maps.newHashMap());
    }

    public Request buildPost(String path, Map<String, String> headers) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        return this.buildPost(path, requestBody, headers);
    }

    public Request buildPost(String path, RequestBody requestBody, Map<String, String> headers) {
        String url = this.buildUrl(path);
        return new Request.Builder().url(url).headers(Headers.of(this.getAllHeaders(headers))).post(requestBody).build();
    }

    public Request buildPut(String path) {
        return this.buildPut(path, Maps.newHashMap());
    }

    public Request buildPut(String path, Map<String, String> headers) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        return this.buildPut(path, requestBody, headers);
    }

    public Request buildPut(String path, RequestBody requestBody, Map<String, String> headers) {
        String url = this.buildUrl(path);
        return new Request.Builder().url(url).headers(Headers.of(this.getAllHeaders(headers))).put(requestBody).build();
    }

    public Request buildDelete(String path, Map<String, String> headers) {
        String url = this.buildUrl(path);
        return new Request.Builder().url(url).headers(Headers.of(this.getAllHeaders(headers))).delete().build();
    }

    public Request buildDelete(String path, RequestBody requestBody, Map<String, String> headers) {
        String url = this.buildUrl(path);
        return new Request.Builder().url(url).headers(Headers.of(this.getAllHeaders(headers))).delete(requestBody).build();
    }

    public RequestBody getJsonRequest(Object data) {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JsonUtil.toJson(data));
    }

    public String encode(String parameter) throws UnsupportedEncodingException {
        return URLEncoder.encode(parameter, "UTF-8");
    }

    private String buildUrl(String path) {
        return SdkEnv.genUrl(path);
    }

    private Map<String, String> getAllHeaders(Map<String, String> headers) {
        headers.putAll(SdkEnv.getSdkHeader());
        return headers;
    }
}

