/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.api;

import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.api.Header;
import com.tencent.bk.devops.atom.common.Constants;
import com.tencent.bk.devops.atom.utils.http.SdkUtils;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkEnv {
    private static final Logger logger = LoggerFactory.getLogger(SdkEnv.class);
    private String buildType;
    private String projectId;
    private String agentId;
    private String secretKey;
    private String gateway;
    private String buildId;
    private String vmSeqId;
    private String fileGateway;
    private static SdkEnv instance;
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";

    public static Map<String, String> getSdkHeader() {
        HashMap map = Maps.newHashMap();
        map.put(Header.AUTH_HEADER_DEVOPS_BUILD_TYPE, SdkEnv.instance.buildType);
        map.put(Header.AUTH_HEADER_DEVOPS_PROJECT_ID, SdkEnv.instance.projectId);
        map.put(Header.AUTH_HEADER_PROJECT_ID, SdkEnv.instance.projectId);
        map.put(Header.AUTH_HEADER_DEVOPS_AGENT_SECRET_KEY, SdkEnv.instance.secretKey);
        map.put(Header.AUTH_HEADER_DEVOPS_AGENT_ID, SdkEnv.instance.agentId);
        map.put(Header.AUTH_HEADER_DEVOPS_VM_SEQ_ID, SdkEnv.instance.vmSeqId);
        map.put(Header.AUTH_HEADER_DEVOPS_BUILD_ID, SdkEnv.instance.buildId);
        map.put(Header.AUTH_HEADER_BUILD_ID, SdkEnv.instance.buildId);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws IOException {
        String dataDir = System.getenv(Constants.DATA_DIR_ENV);
        if (dataDir == null || dataDir.trim().length() == 0 || !new File(dataDir).isDirectory()) {
            dataDir = System.getProperty("user.dir");
        }
        String sdkFile = ".sdk.json";
        File file = new File(dataDir + "/" + sdkFile);
        try {
            String json = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            instance = JsonUtil.fromJson(json, SdkEnv.class);
        }
        finally {
            boolean flag = file.delete();
            logger.info("[java-atom-sdk] delete sdkFile result is:{}", (Object)flag);
        }
    }

    public static String genUrl(String path) {
        String newPath = path.trim();
        if (newPath.startsWith(HTTP_PROTOCOL) || newPath.startsWith(HTTPS_PROTOCOL)) {
            return newPath;
        }
        Object urlPrefix = SdkEnv.instance.gateway;
        if (!SdkUtils.hasProtocol(SdkEnv.instance.gateway).booleanValue()) {
            urlPrefix = HTTP_PROTOCOL + SdkEnv.instance.gateway;
        }
        return (String)urlPrefix + "/" + StringUtils.removeStart((String)newPath, (String)"/");
    }

    public static String getGatewayHost() {
        String host = SdkEnv.instance.gateway;
        if (host.startsWith(HTTP_PROTOCOL)) {
            host = host.replace(HTTP_PROTOCOL, "");
        } else if (host.startsWith(HTTPS_PROTOCOL)) {
            host = host.replace(HTTPS_PROTOCOL, "");
        }
        return host;
    }

    public static String getVmSeqId() {
        return SdkEnv.instance.vmSeqId;
    }

    public static String getFileGateway() {
        return SdkEnv.instance.fileGateway;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public void setVmSeqId(String vmSeqId) {
        this.vmSeqId = vmSeqId;
    }

    public void setFileGateway(String fileGateway) {
        this.fileGateway = fileGateway;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getBuildId() {
        return this.buildId;
    }
}

